/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.message;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.ldap.client.api.exception.LdapException;
import org.apache.directory.ldap.client.api.message.Message;
import org.apache.directory.shared.ldap.message.control.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Message {
    private Map<String, Control> controls = new HashMap<String, Control>();
    private int messageId = -1;

    protected AbstractMessage() {
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    @Override
    public Message add(Control ... controls) {
        if (this.controls == null) {
            this.controls = new HashMap<String, Control>();
        }
        if (controls != null) {
            for (Control control : controls) {
                this.controls.put(control.getOid(), control);
            }
        }
        return this;
    }

    @Override
    public Map<String, Control> getControls() {
        return this.controls;
    }

    @Override
    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    @Override
    public boolean hasControl(String oid) {
        return this.controls != null && this.controls.size() > 0;
    }

    @Override
    public Message remove(Control ... controls) throws LdapException {
        if (this.controls == null) {
            return this;
        }
        if (controls != null) {
            for (Control ctrl : controls) {
                this.controls.remove(ctrl.getOid());
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LdapMessage\n");
        sb.append("    message Id : ").append(this.messageId).append('\n');
        if (this.controls != null) {
            sb.append("    controls :\n");
            for (Control control : this.controls.values()) {
                sb.append("        ").append(control.getClass().getSimpleName());
                sb.append(":").append(control.getOid()).append("\n");
            }
        }
        return sb.toString();
    }
}

