/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    private final Map<String, CFMetaData> cfMetaData;
    public final boolean durableWrites;

    KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs) {
        this.name = name;
        this.strategyClass = strategyClass == null ? NetworkTopologyStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
        this.durableWrites = durableWrites;
    }

    public static KSMetaData newKeyspace(String name, String strategyName, Map<String, String> options) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(strategyName);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        return new KSMetaData(name, cls, options, true, Collections.<CFMetaData>emptyList());
    }

    public static KSMetaData cloneWith(KSMetaData ksm, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.durableWrites, cfDefs);
    }

    public static KSMetaData systemKeyspace() {
        List<CFMetaData> cfDefs = Arrays.asList(CFMetaData.StatusCf, CFMetaData.HintsCf, CFMetaData.MigrationsCf, CFMetaData.SchemaCf, CFMetaData.IndexCf, CFMetaData.NodeIdCf, CFMetaData.VersionCf, CFMetaData.SchemaKeyspacesCf, CFMetaData.SchemaColumnFamiliesCf, CFMetaData.SchemaColumnsCf);
        return new KSMetaData("system", LocalStrategy.class, Collections.<String, String>emptyMap(), true, cfDefs);
    }

    public static KSMetaData testMetadata(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, true, Arrays.asList(cfDefs));
    }

    public static KSMetaData testMetadataNotDurable(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, false, Arrays.asList(cfDefs));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)obj;
        return other.name.equals(this.name) && ObjectUtils.equals(other.strategyClass, this.strategyClass) && ObjectUtils.equals(other.strategyOptions, this.strategyOptions) && ((Object)other.cfMetaData).equals(this.cfMetaData) && other.durableWrites == this.durableWrites;
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(", rep strategy:").append(this.strategyClass.getSimpleName()).append("{").append(StringUtils.join(this.cfMetaData.values(), (String)", ")).append("}").append(", durable_writes: ").append(this.durableWrites);
        return sb.toString();
    }

    public static String convertOldStrategyName(String name) {
        return name.replace("RackUnawareStrategy", "SimpleStrategy").replace("RackAwareStrategy", "OldNetworkTopologyStrategy");
    }

    public static Map<String, String> optsWithRF(Integer rf) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("replication_factor", rf.toString());
        return ret;
    }

    public static KSMetaData fromThrift(KsDef ksd, CFMetaData ... cfDefs) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(ksd.strategy_class);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        return new KSMetaData(ksd.name, cls, ksd.strategy_options == null ? Collections.emptyMap() : ksd.strategy_options, ksd.durable_writes, Arrays.asList(cfDefs));
    }

    public KsDef toThrift() {
        ArrayList<CfDef> cfDefs = new ArrayList<CfDef>(this.cfMetaData.size());
        for (CFMetaData cfm : this.cfMetaData().values()) {
            cfDefs.add(cfm.toThrift());
        }
        KsDef ksdef = new KsDef(this.name, this.strategyClass.getName(), cfDefs);
        ksdef.setStrategy_options(this.strategyOptions);
        ksdef.setDurable_writes(this.durableWrites);
        return ksdef;
    }

    public RowMutation toSchemaUpdate(KSMetaData newState, long modificationTimestamp) {
        return newState.toSchema(modificationTimestamp);
    }

    public KSMetaData validate() throws ConfigurationException {
        if (!CFMetaData.isNameValid(this.name)) {
            throw new ConfigurationException(String.format("Invalid keyspace name: shouldn't be empty nor more than %s characters long (got \"%s\")", 48, this.name));
        }
        TokenMetadata tmd = StorageService.instance.getTokenMetadata();
        IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
        AbstractReplicationStrategy.createReplicationStrategy(this.name, this.strategyClass, tmd, eps, this.strategyOptions);
        for (CFMetaData cfm : this.cfMetaData.values()) {
            cfm.validate();
        }
        return this;
    }

    public KSMetaData reloadAttributes() throws IOException {
        Row ksDefRow = SystemTable.readSchemaRow(this.name);
        if (ksDefRow.cf == null) {
            throw new IOException(String.format("%s not found in the schema definitions table (%s).", this.name, "schema_keyspaces"));
        }
        return KSMetaData.fromSchema(ksDefRow, Collections.<CFMetaData>emptyList());
    }

    public RowMutation dropFromSchema(long timestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.name));
        rm.delete(new QueryPath("schema_keyspaces"), timestamp);
        rm.delete(new QueryPath("schema_columnfamilies"), timestamp);
        rm.delete(new QueryPath("schema_columns"), timestamp);
        return rm;
    }

    public RowMutation toSchema(long timestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.name));
        ColumnFamily cf = rm.addOrGet("schema_keyspaces");
        cf.addColumn(Column.create(this.name, timestamp, "name"));
        cf.addColumn(Column.create(this.durableWrites, timestamp, "durable_writes"));
        cf.addColumn(Column.create(this.strategyClass.getName(), timestamp, "strategy_class"));
        cf.addColumn(Column.create(FBUtilities.json(this.strategyOptions), timestamp, "strategy_options"));
        for (CFMetaData cfm : this.cfMetaData.values()) {
            cfm.toSchema(rm, timestamp);
        }
        return rm;
    }

    public static KSMetaData fromSchema(Row row, Iterable<CFMetaData> cfms) throws IOException {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_keyspaces", row).one();
        try {
            return new KSMetaData(result.getString("name"), AbstractReplicationStrategy.getClass(result.getString("strategy_class")), FBUtilities.fromJsonMap(result.getString("strategy_options")), result.getBoolean("durable_writes"), cfms);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static KSMetaData fromSchema(Row serializedKs, Row serializedCFs) throws IOException {
        Map<String, CFMetaData> cfs = KSMetaData.deserializeColumnFamilies(serializedCFs);
        return KSMetaData.fromSchema(serializedKs, cfs.values());
    }

    public static Map<String, CFMetaData> deserializeColumnFamilies(Row row) {
        if (row.cf == null) {
            return Collections.emptyMap();
        }
        HashMap<String, CFMetaData> cfms = new HashMap<String, CFMetaData>();
        UntypedResultSet results = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row);
        for (UntypedResultSet.Row result : results) {
            CFMetaData cfm = CFMetaData.fromSchema(result);
            cfms.put(cfm.cfName, cfm);
        }
        for (CFMetaData cfm : cfms.values()) {
            Row columnRow = ColumnDefinition.readSchema(cfm.ksName, cfm.cfName);
            for (ColumnDefinition cd : ColumnDefinition.fromSchema(columnRow, cfm)) {
                cfm.column_metadata.put(cd.name, cd);
            }
        }
        return cfms;
    }
}

