/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.processor.RedeliveryPolicy;

public final class ErrorHandlerRenderer {
    private ErrorHandlerRenderer() {
    }

    public static void render(StringBuilder buffer, ErrorHandlerBuilder errorHandler) {
        if (errorHandler instanceof DeadLetterChannelBuilder) {
            String handledPolicy;
            RedeliveryPolicy redelivery;
            long redeliverDelay;
            DeadLetterChannelBuilder deadLetter = (DeadLetterChannelBuilder)errorHandler;
            buffer.append("errorHandler(deadLetterChannel(\"").append(deadLetter.getDeadLetterUri()).append("\")");
            int maxRediliveries = deadLetter.getRedeliveryPolicy().getMaximumRedeliveries();
            if (maxRediliveries != 0) {
                buffer.append(".maximumRedeliveries(").append(maxRediliveries).append(")");
            }
            if ((redeliverDelay = (redelivery = deadLetter.getRedeliveryPolicy()).getRedeliverDelay()) != 1000L) {
                buffer.append(".redeliverDelay(").append(redeliverDelay).append(")");
            }
            if (redelivery.isLogStackTrace()) {
                buffer.append(".logStackTrace(true)");
            }
            if (deadLetter.getHandledPolicy() != null && (handledPolicy = deadLetter.getHandledPolicy().toString()).equals("false")) {
                buffer.append(".handled(").append(handledPolicy).append(")");
            }
            buffer.append(");");
        }
    }
}

