/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpComponent
extends DefaultComponent {
    public static final String MLLP_LOG_PHI_PROPERTY = "org.apache.camel.component.mllp.logPHI";
    public static final String MLLP_LOG_PHI_MAX_BYTES_PROPERTY = "org.apache.camel.component.mllp.logPHI.maxBytes";
    public static final String MLLP_DEFAULT_CHARSET_PROPERTY = "org.apache.camel.component.mllp.charset.default";
    public static final boolean DEFAULT_LOG_PHI = true;
    public static final int DEFAULT_LOG_PHI_MAX_BYTES = 5120;
    static Logger log = LoggerFactory.getLogger(MllpComponent.class);
    @Metadata(label="advanced", defaultValue="true")
    static Boolean logPhi;
    @Metadata(label="advanced", defaultValue="5120")
    static Integer logPhiMaxBytes;
    @Metadata(label="advanced", defaultValue="ISO-8859-1")
    static Charset defaultCharset;
    MllpConfiguration configuration;

    public MllpComponent() {
    }

    public MllpComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uriString, String remaining, Map<String, Object> parameters) throws Exception {
        MllpEndpoint endpoint = new MllpEndpoint(uriString, this, this.hasConfiguration() ? this.configuration.copy() : new MllpConfiguration());
        this.setProperties((Object)endpoint, parameters);
        int colonIndex = remaining.indexOf(58);
        if (-1 != colonIndex) {
            endpoint.setHostname(remaining.substring(0, colonIndex));
            endpoint.setPort(Integer.parseInt(remaining.substring(colonIndex + 1)));
        } else {
            endpoint.setPort(Integer.parseInt(remaining));
        }
        return endpoint;
    }

    public static boolean hasLogPhi() {
        return logPhi != null;
    }

    public static boolean isLogPhi() {
        if (MllpComponent.hasLogPhi()) {
            return logPhi;
        }
        boolean answer = true;
        String logPhiProperty = System.getProperty(MLLP_LOG_PHI_PROPERTY);
        if (logPhiProperty != null) {
            answer = Boolean.valueOf(logPhiProperty);
        }
        return answer;
    }

    public static void setLogPhi(Boolean logPhi) {
        MllpComponent.logPhi = logPhi;
    }

    public static boolean hasLogPhiMaxBytes() {
        return logPhiMaxBytes != null;
    }

    public static int getLogPhiMaxBytes() {
        if (MllpComponent.hasLogPhiMaxBytes()) {
            return logPhiMaxBytes;
        }
        int answer = 5120;
        String logPhiProperty = System.getProperty(MLLP_LOG_PHI_MAX_BYTES_PROPERTY);
        if (logPhiProperty != null && !logPhiProperty.isEmpty()) {
            try {
                answer = Integer.valueOf(logPhiProperty);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Invalid Interger value '{}' for system property {} - using default value of {}", new Object[]{logPhiProperty, MLLP_LOG_PHI_MAX_BYTES_PROPERTY, answer});
            }
        }
        return answer;
    }

    public static void setLogPhiMaxBytes(Integer logPhiMaxBytes) {
        MllpComponent.logPhiMaxBytes = logPhiMaxBytes;
    }

    public static boolean hasDefaultCharset() {
        return defaultCharset != null;
    }

    public static Charset getDefaultCharset() {
        block6: {
            if (MllpComponent.hasDefaultCharset()) {
                return defaultCharset;
            }
            String defaultCharacterSetNamePropertyValue = System.getProperty(MLLP_DEFAULT_CHARSET_PROPERTY);
            if (defaultCharacterSetNamePropertyValue != null && !defaultCharacterSetNamePropertyValue.isEmpty()) {
                try {
                    if (Charset.isSupported(defaultCharacterSetNamePropertyValue)) {
                        defaultCharset = Charset.forName(defaultCharacterSetNamePropertyValue);
                        break block6;
                    }
                    defaultCharset = StandardCharsets.ISO_8859_1;
                    log.warn("Unsupported character set name '{}' in system property {} - using character set {} as default", new Object[]{defaultCharacterSetNamePropertyValue, MLLP_DEFAULT_CHARSET_PROPERTY, defaultCharset});
                }
                catch (Exception charsetEx) {
                    defaultCharset = StandardCharsets.ISO_8859_1;
                    log.warn("Exception encountered determining character set for '{}' found in  system property {} - using default value of {}", new Object[]{defaultCharacterSetNamePropertyValue, MLLP_DEFAULT_CHARSET_PROPERTY, defaultCharset});
                }
            } else {
                defaultCharset = StandardCharsets.ISO_8859_1;
            }
        }
        return defaultCharset;
    }

    public static void setDefaultCharset(String defaultCharacterSetName) {
        if (defaultCharacterSetName != null && !defaultCharacterSetName.isEmpty()) {
            try {
                if (Charset.isSupported(defaultCharacterSetName)) {
                    defaultCharset = Charset.forName(defaultCharacterSetName);
                } else {
                    log.warn("Unsupported character set name '{}' in system property {} - continuing to use character set {} as default", (Object)defaultCharacterSetName, (Object)defaultCharset);
                }
            }
            catch (Exception charsetEx) {
                defaultCharset = StandardCharsets.ISO_8859_1;
                log.warn("Exception encountered determining character set for '{}' - continuing to use character set {} as default", (Object)defaultCharacterSetName, (Object)defaultCharset);
            }
        }
    }

    public static void setDefaultCharset(Charset defaultCharset) {
        if (defaultCharset != null) {
            MllpComponent.defaultCharset = defaultCharset;
        }
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public MllpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MllpConfiguration configuration) {
        this.configuration = configuration;
    }
}

