/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPUtil {
    private static final Log log = LogFactory.getLog((Class)SOAPUtil.class);

    public boolean processPostRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        try {
            response.setHeader("Content-Type", "text/html");
            if (this.server(msgContext) != null) {
                response.setHeader("Server", this.server(msgContext));
            }
            String soapAction = request.getHeader("SOAPAction");
            msgContext.setProperty("ContentType", request.getContentType());
            Handler.InvocationResponse ir = HTTPTransportUtils.processHTTPPostRequest(msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), request.getContentType(), soapAction, request.getRequestURL().toString());
            response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
            if (!TransportUtils.isResponseWritten(msgContext)) {
                Integer statusCode = (Integer)msgContext.getProperty("RESPONSE_CODE");
                if (statusCode != null) {
                    response.setStatus(statusCode.intValue());
                } else {
                    response.setStatus(202);
                }
            }
            boolean closeReader = true;
            Parameter parameter = msgContext.getConfigurationContext().getAxisConfiguration().getParameter("axis2.close.reader");
            if (parameter != null) {
                closeReader = JavaUtils.isTrueExplicitly(parameter.getValue());
            }
            if (closeReader && !Handler.InvocationResponse.SUSPEND.equals(ir)) {
                try {
                    ((StAXBuilder)msgContext.getEnvelope().getBuilder()).close();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
            return true;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException ioException) {
            throw AxisFault.makeFault(ioException);
        }
    }

    private String server(MessageContext messageContext) {
        if (messageContext.getParameter("server") != null) {
            OMElement userAgentElement = messageContext.getParameter("server").getParameterElement();
            return userAgentElement.getText().trim();
        }
        return null;
    }
}

