/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EventFacade;
import org.andromda.metafacades.uml.FrontEndAction;
import org.andromda.metafacades.uml.FrontEndControllerOperation;
import org.andromda.metafacades.uml.FrontEndEvent;
import org.andromda.metafacades.uml.FrontEndForward;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.StateVertexFacade;
import org.andromda.metafacades.uml.TransitionFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.FrontEndParameterLogic;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class FrontEndParameterLogicImpl
extends FrontEndParameterLogic {
    private static final long serialVersionUID = 2219144832310011722L;

    public FrontEndParameterLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected boolean handleIsControllerOperationArgument() {
        return this.getControllerOperation() != null;
    }

    protected OperationFacade handleGetControllerOperation() {
        return this.getOperation();
    }

    @Override
    protected boolean handleIsContainedInFrontEndUseCase() {
        return this.getEvent() instanceof FrontEndEvent || this.getOperation() instanceof FrontEndControllerOperation;
    }

    @Override
    protected Object handleGetView() {
        StateVertexFacade view = null;
        EventFacade event = this.getEvent();
        if (event != null) {
            FrontEndForward forward;
            TransitionFacade transition = event.getTransition();
            if (transition instanceof FrontEndAction) {
                FrontEndAction action = (FrontEndAction)transition;
                view = action.getInput();
            } else if (transition instanceof FrontEndForward && (forward = (FrontEndForward)transition).isEnteringView()) {
                view = forward.getTarget();
            }
        }
        return view;
    }

    @Override
    protected boolean handleIsActionParameter() {
        FrontEndAction action = this.getAction();
        return action != null && action.getParameters().contains(this.THIS());
    }

    protected FrontEndAction handleGetAction() {
        TransitionFacade transition;
        TransitionFacade actionObject = null;
        EventFacade event = this.getEvent();
        if (event != null && (transition = event.getTransition()) instanceof FrontEndAction) {
            actionObject = transition;
        }
        return (FrontEndAction)actionObject;
    }

    @Override
    protected boolean handleIsTable() {
        boolean isTable = false;
        ClassifierFacade type = this.getType();
        if (type != null) {
            boolean bl = isTable = type.isCollectionType() || type.isArrayType();
            if (isTable) {
                String tableTaggedValue = ObjectUtils.toString((Object)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PRESENTATION_IS_TABLE));
                boolean bl2 = isTable = StringUtils.isNotBlank((String)tableTaggedValue) ? Boolean.valueOf(tableTaggedValue.trim()) : true;
                if (!isTable) {
                    isTable = !this.getTableColumnNames().isEmpty();
                }
            }
        }
        return isTable && this.getOperation() == null;
    }

    @Override
    protected Collection<String> handleGetTableColumnNames() {
        LinkedHashSet<String> tableColumnNames = new LinkedHashSet<String>();
        Collection taggedValues = this.findTaggedValues(UMLProfile.TAGGEDVALUE_PRESENTATION_TABLE_COLUMNS);
        if (!taggedValues.isEmpty()) {
            Iterator iterator = taggedValues.iterator();
            while (iterator.hasNext()) {
                String taggedValue = StringUtils.trimToNull((String)String.valueOf(iterator.next()));
                if (taggedValue == null) continue;
                String[] properties = taggedValue.split("[,\\s]+");
                for (int ctr = 0; ctr < properties.length; ++ctr) {
                    String property = properties[ctr];
                    tableColumnNames.add(property);
                }
            }
        }
        if (tableColumnNames.isEmpty()) {
            tableColumnNames.addAll(this.getTableAttributeNames());
        }
        return tableColumnNames;
    }

    @Override
    protected Collection<String> handleGetTableColumns() {
        ArrayList<String> tableColumns = new ArrayList<String>(this.getNonArrayAttributes());
        final Collection<String> tableColumnNames = this.getTableColumnNames();
        CollectionUtils.filter(tableColumns, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ModelElementFacade attribute = (ModelElementFacade)object;
                String attributeName = attribute.getName();
                return attributeName != null && tableColumnNames.contains(attributeName);
            }
        });
        return tableColumns;
    }

    private Collection getNonArrayAttributes() {
        ClassifierFacade nonArrayType;
        ArrayList nonArrayAttributes = new ArrayList();
        ClassifierFacade type = this.getType();
        if (type != null && type.isArrayType() && (nonArrayType = type.getNonArray()) != null) {
            nonArrayAttributes.addAll(nonArrayType.getAttributes(true));
        }
        return nonArrayAttributes;
    }

    @Override
    protected Collection<String> handleGetTableAttributeNames() {
        ArrayList<String> tableAttributeNames = new ArrayList<String>(this.getNonArrayAttributes());
        CollectionUtils.transform(tableAttributeNames, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((AttributeFacade)object).getName();
            }
        });
        return tableAttributeNames;
    }
}

