/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import java.util.List;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml14.EnumerationFacadeLogic;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.omg.uml.foundation.core.Classifier;

public class EnumerationFacadeLogicImpl
extends EnumerationFacadeLogic {
    private static final long serialVersionUID = -3790826922365025369L;

    public EnumerationFacadeLogicImpl(Classifier metaObject, String context) {
        super((Object)metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("enumerationNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected Collection<AttributeFacade> handleGetLiterals() {
        List<AttributeFacade> literals = this.getAttributes();
        CollectionUtils.filter(literals, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean isLiteral = true;
                AttributeFacade attribute = (AttributeFacade)object;
                if (attribute.isEnumerationMember()) {
                    isLiteral = false;
                }
                return isLiteral;
            }
        });
        return literals;
    }

    @Override
    protected Collection<AttributeFacade> handleGetMemberVariables() {
        List<AttributeFacade> variables = super.getAttributes();
        CollectionUtils.filter(variables, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean isMember = false;
                AttributeFacade attribute = (AttributeFacade)object;
                if (attribute.isEnumerationMember()) {
                    isMember = true;
                }
                return isMember;
            }
        });
        return variables;
    }

    @Override
    protected String handleGetFromOperationSignature() {
        StringBuilder signature = new StringBuilder(this.getFromOperationName());
        ClassifierFacade type = this.getLiteralType();
        if (type != null) {
            signature.append('(');
            signature.append(type.getFullyQualifiedName());
            signature.append(" value)");
        }
        return signature.toString();
    }

    @Override
    protected boolean handleIsTypeSafe() {
        return BooleanUtils.toBoolean((String)String.valueOf(this.getConfiguredProperty("typeSafeEnumsEnabled")));
    }

    @Override
    protected String handleGetFromOperationName() {
        StringBuilder name = new StringBuilder("from");
        ClassifierFacade type = this.getLiteralType();
        if (type != null) {
            name.append(StringUtils.capitalize((String)type.getName()));
        }
        return name.toString();
    }

    protected ClassifierFacade handleGetLiteralType() {
        ClassifierFacade type = null;
        Collection<AttributeFacade> literals = this.getLiterals();
        if (literals != null && !literals.isEmpty()) {
            type = literals.iterator().next().getType();
        }
        return type;
    }
}

