/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.EntityQueryOperation;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.EntityLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;

public class EntityLogicImpl
extends EntityLogic {
    private static final long serialVersionUID = 8742467678618468728L;
    private static final Collection dynamicIdentifiersPresent = new ArrayList();

    public EntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    public void initialize() {
        super.initialize();
        if (!this.isIdentifiersPresent() && this.isAllowDefaultIdentifiers()) {
            this.createIdentifier();
            dynamicIdentifiersPresent.add(this.getId());
        }
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("entityNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected Collection<OperationFacade> handleGetQueryOperations() {
        return this.getQueryOperations(false);
    }

    @Override
    protected Collection<OperationFacade> handleGetQueryOperations(boolean follow) {
        ArrayList<OperationFacade> operations = new ArrayList<OperationFacade>(this.getOperations());
        ArrayList<OperationFacade> queryOperations = new ArrayList<OperationFacade>();
        MetafacadeUtils.filterByType(operations, EntityQueryOperation.class);
        for (OperationFacade operation : operations) {
            queryOperations.add((OperationFacade)((EntityQueryOperation)operation));
        }
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            if (!Entity.class.isAssignableFrom(superClass.getClass())) continue;
            Entity entity = (Entity)superClass;
            queryOperations.addAll(entity.getQueryOperations());
        }
        return queryOperations;
    }

    @Override
    protected Collection<EntityAttribute> handleGetIdentifiers() {
        return this.getIdentifiers(true);
    }

    @Override
    protected Collection<EntityAttribute> handleGetIdentifiers(boolean follow) {
        return EntityMetafacadeUtils.getIdentifiers((Entity)this, (boolean)follow);
    }

    private void createIdentifier() {
        if (!this.checkForAndAddForeignIdentifiers()) {
            this.createIdentifier(this.getDefaultIdentifier(), this.getDefaultIdentifierType(), this.getDefaultIdentifierVisibility());
        }
    }

    private void createIdentifier(String name, String type, String visibility) {
        Classifier classifier = (Classifier)this.metaObject;
        if (!classifier.getGeneralization().isEmpty()) {
            return;
        }
        if (!UML14MetafacadeUtils.attributeExists(classifier, name)) {
            Attribute identifier = UML14MetafacadeUtils.createAttribute(name, type, visibility, "::");
            identifier.getStereotype().add(UML14MetafacadeUtils.findOrCreateStereotype(UMLProfile.STEREOTYPE_IDENTIFIER));
            classifier.getFeature().add(identifier);
        }
    }

    @Override
    protected boolean handleIsIdentifiersPresent() {
        Collection identifiers = this.getIdentifiers(true);
        return identifiers != null && !identifiers.isEmpty();
    }

    @Override
    protected boolean handleIsDynamicIdentifiersPresent() {
        return dynamicIdentifiersPresent.contains(this.getId());
    }

    @Override
    protected String handleGetTableName() {
        String prefixProperty = "tableNamePrefix";
        String tableNamePrefix = this.isConfiguredProperty("tableNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("tableNamePrefix")) : null;
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue((String)tableNamePrefix, (ModelElementFacade)this, (String)UMLProfile.TAGGEDVALUE_PERSISTENCE_TABLE, (Short)this.getMaxSqlNameLength(), (Object)this.getConfiguredProperty("sqlNameSeparator"));
    }

    @Override
    protected String handleGetOperationCallFromAttributes(boolean withIdentifiers) {
        return this.getOperationCallFromAttributes(withIdentifiers, false);
    }

    @Override
    protected String handleGetOperationCallFromAttributes(boolean withIdentifiers, boolean follow) {
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        buffer.append('(');
        ArrayList<AttributeFacade> attributes = new ArrayList<AttributeFacade>(this.getAttributes());
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            if (!(superClass instanceof Entity)) continue;
            Entity entity = (Entity)superClass;
            attributes.addAll(entity.getAttributes());
        }
        if (!attributes.isEmpty()) {
            for (EntityAttribute entityAttribute : attributes) {
                if (!withIdentifiers && entityAttribute.isIdentifier()) continue;
                buffer.append(separator);
                if (entityAttribute.getType() != null) {
                    buffer.append(entityAttribute.getType().getFullyQualifiedName());
                }
                buffer.append(' ');
                buffer.append(entityAttribute.getName());
                separator = ", ";
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected String handleGetAttributeTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetAttributeNameList(boolean follow, boolean withIdentifiers) {
        return this.getNameList(this.getAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetAttributeNameList(boolean follow, boolean withIdentifiers, boolean withDerived) {
        return this.getNameList(this.getAttributes(follow, withIdentifiers, withDerived));
    }

    @Override
    protected String handleGetRequiredAttributeTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getRequiredAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredAttributeNameList(boolean follow, boolean withIdentifiers) {
        return this.getNameList(this.getRequiredAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredPropertyTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getRequiredProperties(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredPropertyNameList(boolean follow, boolean withIdentifiers) {
        return this.getNameList(this.getRequiredProperties(follow, withIdentifiers));
    }

    private String getTypeList(Collection attributes) {
        final StringBuilder list = new StringBuilder();
        String comma = ", ";
        CollectionUtils.forAllDo((Collection)attributes, (Closure)new Closure(){

            public void execute(Object object) {
                AssociationEndFacade associationEnd;
                AttributeFacade attribute;
                if (object instanceof AttributeFacade && (attribute = (AttributeFacade)object).getType() != null) {
                    list.append(attribute.getType().getFullyQualifiedName());
                    list.append(", ");
                }
                if (object instanceof AssociationEndFacade && (associationEnd = (AssociationEndFacade)object).getType() != null) {
                    list.append(associationEnd.getType().getFullyQualifiedName());
                    list.append(", ");
                }
            }
        });
        if (list.toString().endsWith(", ")) {
            list.delete(list.lastIndexOf(", "), list.length());
        }
        return list.toString();
    }

    private String getNameList(Collection properties) {
        final StringBuilder list = new StringBuilder();
        String comma = ", ";
        CollectionUtils.forAllDo((Collection)properties, (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof EntityAttribute) {
                    list.append(((AttributeFacade)object).getName());
                    list.append(", ");
                }
                if (object instanceof EntityAssociationEnd) {
                    list.append(((AssociationEndFacade)object).getName());
                    list.append(", ");
                }
            }
        });
        if (list.toString().endsWith(", ")) {
            list.delete(list.lastIndexOf(", "), list.length());
        }
        return list.toString();
    }

    @Override
    protected boolean handleIsChild() {
        return CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd().isComposition();
            }
        }) != null;
    }

    protected AssociationEndFacade handleGetParentEnd() {
        AssociationEndFacade parentEnd = null;
        AssociationEndFacade end = (AssociationEndFacade)CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd().isComposition();
            }
        });
        if (end != null) {
            parentEnd = end.getOtherEnd();
        }
        return parentEnd;
    }

    @Override
    protected Collection<AssociationEndFacade> handleGetChildEnds() {
        FilteredCollection childEnds = new FilteredCollection(this.getAssociationEnds()){
            private static final long serialVersionUID = -4602337379703645043L;

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).isComposition();
            }
        };
        CollectionUtils.transform((Collection)childEnds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        return childEnds;
    }

    @Override
    protected Collection<OperationFacade> handleGetBusinessOperations() {
        ArrayList<OperationFacade> businessOperations = new ArrayList<OperationFacade>(this.getImplementationOperations());
        MetafacadeUtils.filterByNotType(businessOperations, EntityQueryOperation.class);
        return businessOperations;
    }

    @Override
    protected Collection<DependencyFacade> handleGetEntityReferences() {
        return new FilteredCollection(this.getSourceDependencies()){
            private static final long serialVersionUID = -8696886289865317133L;

            public boolean evaluate(Object object) {
                ModelElementFacade targetElement = ((DependencyFacade)object).getTargetElement();
                return targetElement instanceof Entity;
            }
        };
    }

    @Override
    protected Collection handleGetAttributes(boolean follow, boolean withIdentifiers) {
        return this.getAttributes(follow, withIdentifiers, true);
    }

    @Override
    protected Collection handleGetAttributes(boolean follow, final boolean withIdentifiers, final boolean withDerived) {
        List attributes = this.getAttributes(follow);
        CollectionUtils.filter((Collection)attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = true;
                if (!withIdentifiers && object instanceof EntityAttribute) {
                    boolean bl = valid = !((EntityAttribute)object).isIdentifier();
                }
                if (valid && !withDerived && object instanceof EntityAttribute) {
                    valid = !((EntityAttribute)object).isDerived();
                }
                return valid;
            }
        });
        return attributes;
    }

    @Override
    protected Collection handleGetProperties(boolean follow, final boolean withIdentifiers) {
        List properties = this.getProperties(follow);
        CollectionUtils.filter((Collection)properties, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = true;
                if (!withIdentifiers && object instanceof EntityAttribute) {
                    valid = !((EntityAttribute)object).isIdentifier();
                }
                return valid;
            }
        });
        return properties;
    }

    @Override
    protected Collection handleGetRequiredAttributes(boolean follow, final boolean withIdentifiers) {
        Collection attributes = this.getAttributes(follow, withIdentifiers, false);
        CollectionUtils.filter((Collection)attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = ((AttributeFacade)object).isRequired();
                if (valid && !withIdentifiers && object instanceof EntityAttribute) {
                    valid = !((EntityAttribute)object).isIdentifier();
                }
                return valid;
            }
        });
        return attributes;
    }

    @Override
    protected Collection handleGetRequiredProperties(boolean follow, final boolean withIdentifiers) {
        LinkedHashSet properties = new LinkedHashSet(this.getProperties(follow, withIdentifiers));
        CollectionUtils.filter(properties, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = false;
                if (object instanceof AttributeFacade) {
                    AttributeFacade attribute = (AttributeFacade)object;
                    boolean bl = valid = attribute.isRequired() && !attribute.isDerived();
                    if (valid && !withIdentifiers && object instanceof EntityAttribute) {
                        valid = !((EntityAttribute)object).isIdentifier();
                    }
                } else if (object instanceof AssociationEndFacade) {
                    valid = ((AssociationEndFacade)object).isRequired();
                }
                return valid;
            }
        });
        ArrayList sortedProperties = new ArrayList(properties);
        MetafacadeUtils.sortByFullyQualifiedName(sortedProperties);
        return sortedProperties;
    }

    @Override
    protected short handleGetMaxSqlNameLength() {
        return Short.valueOf((String)this.getConfiguredProperty("maxSqlNameLength"));
    }

    private boolean isAllowDefaultIdentifiers() {
        return Boolean.valueOf((String)this.getConfiguredProperty("allowDefaultIdentifiers"));
    }

    private String getDefaultIdentifier() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty("defaultIdentifierPattern")).replaceAll("\\{0\\}", StringUtilsHelper.lowerCamelCaseName((String)this.getName()));
    }

    private String getDefaultIdentifierType() {
        return (String)this.getConfiguredProperty("defaultIdentifierType");
    }

    private String getDefaultIdentifierVisibility() {
        return (String)this.getConfiguredProperty("defaultIdentifierVisibility");
    }

    private boolean checkForAndAddForeignIdentifiers() {
        boolean identifiersAdded = false;
        EntityAssociationEnd end = this.getForeignIdentifierEnd();
        if (end != null && end.getType() instanceof Entity) {
            Entity foreignEntity = (Entity)end.getOtherEnd().getType();
            Collection identifiers = EntityMetafacadeUtils.getIdentifiers((Entity)foreignEntity, (boolean)true);
            for (AttributeFacade identifier : identifiers) {
                this.createIdentifier(identifier.getName(), identifier.getType().getFullyQualifiedName(true), identifier.getVisibility());
                identifiersAdded = true;
            }
        }
        return identifiersAdded;
    }

    @Override
    public List handleGetAssociationEnds() {
        List associationEnds = this.shieldedElements(super.handleGetAssociationEnds());
        CollectionUtils.filter((Collection)associationEnds, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd().getType() instanceof Entity;
            }
        });
        return associationEnds;
    }

    @Override
    protected boolean handleIsUsingForeignIdentifier() {
        return this.getForeignIdentifierEnd() != null;
    }

    private EntityAssociationEnd getForeignIdentifierEnd() {
        return (EntityAssociationEnd)CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = false;
                if (object != null && EntityAssociationEnd.class.isAssignableFrom(object.getClass())) {
                    EntityAssociationEnd end = (EntityAssociationEnd)object;
                    valid = end.isForeignIdentifier();
                }
                return valid;
            }
        });
    }

    @Override
    protected boolean handleIsUsingAssignedIdentifier() {
        boolean assigned = false;
        Collection<EntityAttribute> identifiers = this.getIdentifiers();
        if (identifiers != null && !identifiers.isEmpty()) {
            AttributeFacade identifier = (AttributeFacade)identifiers.iterator().next();
            assigned = Boolean.valueOf(ObjectUtils.toString((Object)identifier.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ASSIGNED_IDENTIFIER)));
        }
        return assigned;
    }

    @Override
    protected String handleGetSchema() {
        String schemaName = ObjectUtils.toString((Object)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_SCHEMA));
        if (StringUtils.isBlank((String)schemaName)) {
            schemaName = ObjectUtils.toString((Object)this.getConfiguredProperty("schemaName"));
        }
        return schemaName;
    }

    @Override
    protected Collection handleGetIdentifierAssociationEnds() {
        ArrayList<AssociationEndFacade> associationEnds = new ArrayList<AssociationEndFacade>(this.getAssociationEnds());
        MetafacadeUtils.filterByStereotype(associationEnds, (String)UMLProfile.STEREOTYPE_IDENTIFIER);
        return associationEnds;
    }

    @Override
    protected boolean handleIsCompositeIdentifier() {
        int identifiers = !this.getIdentifiers().isEmpty() ? this.getIdentifiers().size() : 0;
        return (identifiers += !this.getIdentifierAssociationEnds().isEmpty() ? this.getIdentifierAssociationEnds().size() : 0) >= 2;
    }

    @Override
    protected Collection<DependencyFacade> handleGetAllEntityReferences() {
        final LinkedHashSet<DependencyFacade> result = new LinkedHashSet<DependencyFacade>();
        result.addAll(this.getEntityReferences());
        CollectionUtils.forAllDo(this.getAllGeneralizations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    result.addAll(entity.getEntityReferences());
                }
            }
        });
        return result;
    }

    @Override
    protected Collection<AttributeFacade> handleGetEmbeddedValues() {
        ArrayList<AttributeFacade> embeddedValues = new ArrayList<AttributeFacade>();
        for (AttributeFacade attribute : this.getAttributes(true)) {
            ClassifierFacade type = attribute.getType();
            if (type == null || !type.isEmbeddedValue()) continue;
            embeddedValues.add(attribute);
        }
        return embeddedValues;
    }

    @Override
    public String handleGetFullyQualifiedIdentifierTypeName() {
        if (this.isCompositeIdentifier()) {
            return this.getFullyQualifiedName() + (String)this.getConfiguredProperty("compositeIdentifierTypeNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getType().getFullyQualifiedName();
    }

    @Override
    public String handleGetIdentifierName() {
        if (this.isCompositeIdentifier()) {
            return StringUtils.uncapitalize((String)this.getName()) + (String)this.getConfiguredProperty("compositeIdentifierNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getName();
    }

    @Override
    public String handleGetIdentifierTypeName() {
        if (this.isCompositeIdentifier()) {
            return this.getName() + (String)this.getConfiguredProperty("compositeIdentifierTypeNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getType().getName();
    }

    @Override
    public String handleGetIdentifierGetterName() {
        return "get" + StringUtils.capitalize((String)this.getIdentifierName());
    }

    @Override
    public String handleGetIdentifierSetterName() {
        return "set" + StringUtils.capitalize((String)this.getIdentifierName());
    }
}

