/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.gal.progress.desktop;

import java.util.HashMap;
import java.util.UUID;
import javax.swing.JProgressBar;
import nu.zoom.gal.progress.Progress;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressImpl
implements Progress,
WorkbenchListener {
    private final Workbench workbench;
    private final Log log = LogFactory.getLog(this.getClass());
    private JProgressBar progressBar;
    private final HashMap<Progress.TaskID, Void> knownTasks = new HashMap();

    public ProgressImpl(Workbench workbench) {
        this.workbench = workbench;
    }

    @Override
    public Progress.TaskID createTask() {
        InternalTaskID taskID = new InternalTaskID();
        this.knownTasks.put(taskID, null);
        return taskID;
    }

    @Override
    public void deleteTask(Progress.TaskID taskID) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Removed task ID: " + taskID));
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            this.knownTasks.remove(taskID);
        }
    }

    @Override
    public void setIndeterminate(Progress.TaskID taskID, boolean value) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Known TaskID: " + taskID));
            this.progressBar.setIndeterminate(value);
        }
    }

    @Override
    public void setMaximum(Progress.TaskID taskID, int max) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Known TaskID: " + taskID));
            this.progressBar.setMaximum(max);
        }
    }

    @Override
    public void setValue(Progress.TaskID taskID, int n) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Known TaskID: " + taskID));
            this.progressBar.setValue(n);
        }
    }

    @Override
    public void setMinimum(Progress.TaskID taskID, int min) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Known TaskID: " + taskID));
            this.progressBar.setMinimum(min);
        }
    }

    @Override
    public void setMessage(Progress.TaskID taskID, CharSequence message) {
        if (this.knownTasks.containsKey(taskID)) {
            this.log.debug((Object)("Known TaskID: " + taskID));
            this.workbench.getStatusbar().setMessage(message != null ? ((Object)message).toString() : "");
        }
    }

    public void start() {
        this.progressBar = new JProgressBar();
    }

    public void close() {
    }

    public void initialize() throws Exception {
        this.workbench.addWorkBenchListener((WorkbenchListener)this);
    }

    public void visible() {
    }

    public final class InternalTaskID
    implements Progress.TaskID {
        private final UUID id = UUID.randomUUID();

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            return this.id.equals(obj);
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

