/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.xml;

import java.util.Stack;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.SystemTools;
import net.timewalker.ffmq4.utils.descriptor.AbstractDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXMLDescriptorHandler
extends DefaultHandler {
    private StringBuilder valueBuffer = new StringBuilder();
    private Stack<String> nameStack = new Stack();

    public abstract AbstractDescriptor getDescriptor();

    protected String getElementValue() {
        return SystemTools.replaceSystemProperties(this.valueBuffer.toString().trim());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.valueBuffer.setLength(0);
        this.nameStack.push(qName);
        String currentPath = StringTools.join(this.nameStack, "/");
        this.before(qName, currentPath, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        String currentPath = StringTools.join(this.nameStack, "/");
        this.onNode(name, currentPath);
        this.nameStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.valueBuffer.append(ch, start, length);
    }

    protected abstract void before(String var1, String var2, Attributes var3) throws SAXException;

    protected abstract void onNode(String var1, String var2) throws SAXException;

    protected String getRequired(Attributes attributes, String attributeName) throws SAXException {
        String value = SystemTools.replaceSystemProperties(attributes.getValue(attributeName));
        if (value == null) {
            throw new SAXException("Missing required attribute : " + attributeName);
        }
        return value;
    }
}

