/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.watchdog;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.timewalker.ffmq4.utils.watchdog.ActiveObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivityWatchdog
extends Thread {
    private static final Log log = LogFactory.getLog(ActivityWatchdog.class);
    private static ActivityWatchdog instance;
    private static long WAKE_UP_INTERVAL;
    private List<WeakReference<ActiveObject>> watchList = new ArrayList<WeakReference<ActiveObject>>();
    private boolean stop;

    public static synchronized ActivityWatchdog getInstance() {
        if (instance == null) {
            instance = new ActivityWatchdog();
            instance.start();
        }
        return instance;
    }

    private ActivityWatchdog() {
        super("ActivityWatchdog");
        this.setDaemon(true);
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        ArrayList<ActiveObject> inactiveList = new ArrayList<ActiveObject>();
        try {
            log.debug((Object)("Starting activity watchdog (wakeUpInterval=" + WAKE_UP_INTERVAL + "ms)"));
            while (!this.stop) {
                this.wait(WAKE_UP_INTERVAL);
                if (this.stop) {
                    return;
                }
                long now = System.currentTimeMillis();
                List<WeakReference<ActiveObject>> list = this.watchList;
                synchronized (list) {
                    for (int i = 0; i < this.watchList.size(); ++i) {
                        WeakReference<ActiveObject> weakRef = this.watchList.get(i);
                        ActiveObject obj = (ActiveObject)weakRef.get();
                        if (obj == null) {
                            this.watchList.remove(i--);
                            continue;
                        }
                        if (now - obj.getLastActivity() <= obj.getTimeoutDelay()) continue;
                        log.trace((Object)("Marking object as inactive : " + obj));
                        inactiveList.add(obj);
                    }
                }
                for (int n = 0; n < inactiveList.size(); ++n) {
                    ActiveObject obj = (ActiveObject)inactiveList.get(n);
                    try {
                        if (obj.onActivityTimeout()) continue;
                        inactiveList.remove(n--);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)"Error notifying an inactive object", (Throwable)e);
                    }
                }
                list = this.watchList;
                synchronized (list) {
                    block13: for (int n = 0; n < inactiveList.size(); ++n) {
                        ActiveObject targetObj = (ActiveObject)inactiveList.get(n);
                        for (int i = 0; i < this.watchList.size(); ++i) {
                            WeakReference<ActiveObject> weakRef = this.watchList.get(i);
                            ActiveObject obj = (ActiveObject)weakRef.get();
                            if (obj != targetObj) continue;
                            log.trace((Object)("Removing inactive object from watch list : " + targetObj));
                            this.watchList.remove(i--);
                            continue block13;
                        }
                    }
                }
                inactiveList.clear();
            }
            log.debug((Object)"Activity watchdog stopped");
        }
        catch (Throwable e) {
            log.error((Object)"Activity watchdog failed", e);
        }
    }

    public synchronized void pleaseStop() {
        this.stop = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ActiveObject object) {
        List<WeakReference<ActiveObject>> list = this.watchList;
        synchronized (list) {
            this.watchList.add(new WeakReference<ActiveObject>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ActiveObject object) {
        List<WeakReference<ActiveObject>> list = this.watchList;
        synchronized (list) {
            for (int i = 0; i < this.watchList.size(); ++i) {
                WeakReference<ActiveObject> weakRef = this.watchList.get(i);
                ActiveObject obj = (ActiveObject)weakRef.get();
                if (obj == null) {
                    this.watchList.remove(i--);
                    continue;
                }
                if (obj != object) continue;
                this.watchList.remove(i);
                break;
            }
        }
    }

    static {
        WAKE_UP_INTERVAL = 2000L;
    }
}

