/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.async;

import java.util.concurrent.Semaphore;
import net.timewalker.ffmq4.utils.async.AsyncTask;
import net.timewalker.ffmq4.utils.async.AsyncTaskProcessorThreadListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncTaskProcessorThread
extends Thread {
    private static final Log log = LogFactory.getLog(AsyncTaskProcessorThread.class);
    private AsyncTaskProcessorThreadListener listener;
    private boolean stopRequired = false;
    private Semaphore waitLock = new Semaphore(0);
    private AsyncTask task;
    private boolean traceEnabled = log.isTraceEnabled();

    protected AsyncTaskProcessorThread(AsyncTaskProcessorThreadListener listener) {
        super("AsyncTaskProcessorThread");
        this.setDaemon(true);
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            while (!this.stopRequired) {
                if (this.traceEnabled) {
                    log.trace((Object)("Thread entering passive wait : " + this.getName()));
                }
                this.waitLock.acquire();
                if (!this.stopRequired) {
                    if (this.traceEnabled) {
                        log.trace((Object)("Executing task " + this.task));
                    }
                    this.task.execute();
                    this.listener.executionComplete(this);
                    continue;
                }
                break;
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Asynchronous execution thread failed", ex);
        }
        log.debug((Object)("Thread exits : " + this.getName()));
    }

    protected void execute() {
        this.waitLock.release();
    }

    protected void setTask(AsyncTask target) {
        this.task = target;
    }

    public void pleaseStop() {
        this.stopRequired = true;
        this.waitLock.release();
    }
}

