/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.async;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jms.JMSException;
import net.timewalker.ffmq4.utils.async.AsyncTask;
import net.timewalker.ffmq4.utils.async.AsyncTaskManagerMBean;
import net.timewalker.ffmq4.utils.async.AsyncTaskProcessorThread;
import net.timewalker.ffmq4.utils.async.AsyncTaskProcessorThreadListener;
import net.timewalker.ffmq4.utils.async.AsyncTaskProcessorThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AsyncTaskManager
implements AsyncTaskProcessorThreadListener,
AsyncTaskManagerMBean {
    private static final Log log = LogFactory.getLog(AsyncTaskManager.class);
    private String name;
    private AsyncTaskProcessorThreadPool threadPool;
    private Set<AsyncTask> taskSet = new HashSet<AsyncTask>();
    private LinkedList<AsyncTask> taskQueue = new LinkedList();

    public AsyncTaskManager(String name, int threadPoolMinSize, int threadPoolMaxIdle, int threadPoolMaxSize) throws JMSException {
        log.debug((Object)("Initializing " + name));
        this.name = name;
        this.threadPool = new AsyncTaskProcessorThreadPool(name, threadPoolMinSize, threadPoolMaxIdle, threadPoolMaxSize, this);
    }

    public synchronized void cancelTask(AsyncTask task) {
        this.taskQueue.remove(task);
    }

    public synchronized void execute(AsyncTask task) throws JMSException {
        AsyncTaskProcessorThread thread = (AsyncTaskProcessorThread)this.threadPool.borrow();
        if (thread != null) {
            thread.setTask(task);
            thread.execute();
        } else {
            if (task.isMergeable() && !this.taskSet.add(task)) {
                return;
            }
            this.taskQueue.add(task);
        }
    }

    @Override
    public synchronized void executionComplete(AsyncTaskProcessorThread thread) {
        if (!this.taskQueue.isEmpty()) {
            AsyncTask nextTask = this.taskQueue.removeFirst();
            if (nextTask.isMergeable()) {
                this.taskSet.remove(nextTask);
            }
            thread.setTask(nextTask);
            thread.execute();
        } else {
            this.threadPool.release(thread);
        }
    }

    public void close() {
        this.threadPool.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTaskQueueSize() {
        return this.taskQueue.size();
    }

    @Override
    public int getThreadPoolMaxIdle() {
        return this.threadPool.getThreadPoolMaxIdle();
    }

    @Override
    public int getThreadPoolMinSize() {
        return this.threadPool.getThreadPoolMinSize();
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPool.getThreadPoolMaxSize();
    }

    @Override
    public int getThreadPoolExhaustionPolicy() {
        return this.threadPool.getThreadPoolExhaustionPolicy();
    }

    @Override
    public long getThreadPoolWaitTimeout() {
        return this.threadPool.getThreadPoolWaitTimeout();
    }

    @Override
    public int getThreadPoolAvailableCount() {
        return this.threadPool.getThreadPoolAvailableCount();
    }

    @Override
    public int getThreadPoolPendingWaits() {
        return this.threadPool.getThreadPoolPendingWaits();
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPool.getThreadPoolSize();
    }
}

