/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.nio;

import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.tcp.SocketUtils;
import net.timewalker.ffmq4.transport.tcp.nio.NIOClientSocketHandler;
import net.timewalker.ffmq4.transport.tcp.nio.NIOServerSocketHandler;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NIOTcpMultiplexer {
    protected static final Log log = LogFactory.getLog(NIOTcpMultiplexer.class);
    protected Selector selector;
    private SelectorThread selectorThread;
    protected int socketSendBufferSize;
    protected int socketRecvBufferSize;
    protected List<NIOServerSocketHandler> pendingAcceptHandlers = new Vector<NIOServerSocketHandler>();
    protected List<NIOServerSocketHandler> serverHandlers = new Vector<NIOServerSocketHandler>();
    protected Map<String, NIOClientSocketHandler> clientHandlers = new Hashtable<String, NIOClientSocketHandler>();
    private boolean waiting;

    public NIOTcpMultiplexer(Settings settings, boolean client) throws PacketTransportException {
        this.socketSendBufferSize = settings.getIntProperty("transport.tcp.socket.sendBufferSize", 65536);
        this.socketRecvBufferSize = settings.getIntProperty("transport.tcp.socket.recvBufferSize", 65536);
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.selectorThread = new SelectorThread(client);
            this.selectorThread.start();
        }
        catch (Exception e) {
            throw new PacketTransportException("Cannot create NIO multiplexer", e);
        }
    }

    private synchronized void wakeUpAndWait() {
        if (!this.selectorThread.isAlive()) {
            return;
        }
        this.selector.wakeup();
        this.waiting = true;
        while (this.waiting) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.error((Object)"Wait was interrupted");
                this.waiting = false;
            }
        }
    }

    protected synchronized void onSelectExit() {
        if (this.waiting) {
            this.waiting = false;
            this.notifyAll();
        }
    }

    public void wakeUp() {
        this.selector.wakeup();
    }

    public void registerServerSocketHandler(NIOServerSocketHandler serverHandler) {
        this.pendingAcceptHandlers.add(serverHandler);
        this.wakeUp();
    }

    public void registerClientSocketHandler(NIOClientSocketHandler clientHandler) {
        this.clientHandlers.put(clientHandler.getId(), clientHandler);
        this.wakeUp();
    }

    public void unregisterServerSocketHandler(NIOServerSocketHandler serverHandler) {
        if (this.pendingAcceptHandlers.remove(serverHandler)) {
            return;
        }
        if (this.serverHandlers.remove(serverHandler)) {
            this.closeSocketChannel(serverHandler.getServerSocketChannel(), this.selector);
            this.wakeUpAndWait();
        }
    }

    public void unregisterClientSocketHandler(NIOClientSocketHandler clientHandler) {
        this.dropClientHandler(clientHandler, this.selector, false);
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropClientHandler(NIOClientSocketHandler clientHandler, Selector selector, boolean linkFailed) {
        Map<String, NIOClientSocketHandler> map = this.clientHandlers;
        synchronized (map) {
            if (this.clientHandlers.remove(clientHandler.getId()) != null) {
                log.debug((Object)("[" + clientHandler.getId() + "] Disconnecting client (" + this.clientHandlers.size() + " remaining)"));
            }
        }
        this.closeSocketChannel(clientHandler.getSocketChannel(), selector);
        if (linkFailed) {
            clientHandler.onSocketChannelClosed();
        }
    }

    private void closeSocketChannel(AbstractSelectableChannel channel, Selector selector) {
        try {
            SelectionKey sk = channel.keyFor(selector);
            if (sk != null && sk.isValid()) {
                sk.cancel();
            }
            if (channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not close channel : " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acceptClient(NIOServerSocketHandler serverHandler, SocketChannel socketChannel) {
        Map<String, NIOClientSocketHandler> map = this.clientHandlers;
        synchronized (map) {
            NIOClientSocketHandler clientHandler = serverHandler.createClientHandler(this, socketChannel);
            if (clientHandler == null) {
                return false;
            }
            this.clientHandlers.put(clientHandler.getId(), clientHandler);
            log.debug((Object)("[" + clientHandler.getId() + "] Accepted new client from " + socketChannel.socket().getInetAddress().getHostAddress() + " (" + this.clientHandlers.size() + ") : " + clientHandler.getId()));
        }
        return true;
    }

    protected boolean readAndProcessChannelData(NIOClientSocketHandler clientHandler) {
        try {
            ByteBuffer inputBuffer = clientHandler.getInputBuffer();
            int readAmount = clientHandler.getSocketChannel().read(inputBuffer);
            if (readAmount <= 0) {
                log.debug((Object)("[" + clientHandler.getId() + "] Cannot read, channel socket was closed"));
                return false;
            }
            inputBuffer.flip();
            boolean status = clientHandler.handleIncomingData();
            inputBuffer.compact();
            return status;
        }
        catch (IOException e) {
            log.debug((Object)("[" + clientHandler.getId() + "] Read failed : " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            log.error((Object)("[" + clientHandler.getId() + "] Could not read channel data"), (Throwable)e);
            return false;
        }
    }

    protected boolean writeAndProcessChannelData(NIOClientSocketHandler clientHandler) {
        try {
            int writeAmount;
            if (!clientHandler.appendOutgoingData()) {
                return false;
            }
            ByteBuffer outputBuffer = clientHandler.getOutputBuffer();
            outputBuffer.flip();
            try {
                writeAmount = clientHandler.getSocketChannel().write(outputBuffer);
                if (writeAmount <= 0) {
                    log.debug((Object)("[" + clientHandler.getId() + "] Cannot write, channel socket was closed"));
                }
            }
            catch (IOException e) {
                log.error((Object)("[" + clientHandler.getId() + "] Write failed : " + e.getMessage()));
                writeAmount = -1;
            }
            outputBuffer.compact();
            return writeAmount > 0;
        }
        catch (Exception e) {
            log.error((Object)("[" + clientHandler.getId() + "] Could not process data"), (Throwable)e);
            return false;
        }
    }

    protected void updateConnectInterest(NIOClientSocketHandler clientHandler, Selector selector) {
        SocketChannel socketChannel = clientHandler.getSocketChannel();
        if (!socketChannel.isOpen()) {
            return;
        }
        if (!socketChannel.isConnected()) {
            this.addInterest(socketChannel, 8, clientHandler, selector);
        } else {
            this.removeInterest(socketChannel, 8, selector);
        }
    }

    protected void updateReadInterest(NIOClientSocketHandler clientHandler, Selector selector) {
        SocketChannel socketChannel = clientHandler.getSocketChannel();
        if (!socketChannel.isOpen()) {
            return;
        }
        if (!socketChannel.isConnected()) {
            return;
        }
        if (clientHandler.getInputBuffer().remaining() > 0) {
            this.addInterest(socketChannel, 1, clientHandler, selector);
        } else {
            this.removeInterest(socketChannel, 1, selector);
        }
    }

    protected void updateWriteInterest(NIOClientSocketHandler clientHandler, Selector selector) {
        SocketChannel socketChannel = clientHandler.getSocketChannel();
        if (!socketChannel.isOpen()) {
            return;
        }
        if (!socketChannel.isConnected()) {
            return;
        }
        if (clientHandler.getOutputBuffer().position() > 0 || clientHandler.hasWriteInterest()) {
            this.addInterest(socketChannel, 4, null, selector);
        } else {
            this.removeInterest(socketChannel, 4, selector);
        }
    }

    protected void addInterest(AbstractSelectableChannel channel, int interest, Object attachment, Selector selector) {
        try {
            SelectionKey sk = channel.keyFor(selector);
            if (sk != null) {
                if (!sk.isValid()) {
                    return;
                }
                int actualInterests = sk.interestOps();
                if ((actualInterests & interest) != interest) {
                    sk.interestOps(actualInterests | interest);
                }
                if (attachment != null) {
                    sk.attach(attachment);
                }
            } else {
                channel.register(selector, interest, attachment);
            }
        }
        catch (ClosedChannelException e) {
            log.warn((Object)"Cannot add interest to selector channel : channel is closed");
        }
    }

    private void removeInterest(AbstractSelectableChannel channel, int interest, Selector selector) {
        int actualInterests;
        SelectionKey sk = channel.keyFor(selector);
        if (sk != null && sk.isValid() && ((actualInterests = sk.interestOps()) & interest) != 0) {
            sk.interestOps(sk.interestOps() & ~interest);
        }
    }

    protected boolean finalizeConnect(NIOClientSocketHandler clientHandler, SocketChannel channel, Selector selector) {
        try {
            channel.finishConnect();
            log.debug((Object)("[" + clientHandler.getId() + "] Connected to " + channel.socket().getInetAddress()));
            this.removeInterest(channel, 8, selector);
            return true;
        }
        catch (SocketException e) {
            log.error((Object)("[" + clientHandler.getId() + "] Could not connect to remote server : " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            log.error((Object)("[" + clientHandler.getId() + "] Could not finalize connection"), (Throwable)e);
            return false;
        }
    }

    public void stop() {
        this.selectorThread.pleaseStop();
    }

    private class SelectorThread
    extends Thread {
        private volatile boolean stopRequired;

        public SelectorThread(boolean client) {
            super("NIOTcpMultiplexer-SelectorThread-" + (client ? "CLIENT" : "SERVER"));
            this.stopRequired = false;
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void pleaseStop() {
            this.stopRequired = true;
            NIOTcpMultiplexer.this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stopRequired) {
                    int selectedCount = NIOTcpMultiplexer.this.selector.select();
                    if (this.stopRequired) break;
                    NIOTcpMultiplexer.this.onSelectExit();
                    if (selectedCount > 0) {
                        Set<SelectionKey> readyKeys = NIOTcpMultiplexer.this.selector.selectedKeys();
                        Iterator<SelectionKey> i = readyKeys.iterator();
                        while (i.hasNext()) {
                            SelectionKey sk = i.next();
                            i.remove();
                            if (!sk.isValid()) continue;
                            try {
                                NIOClientSocketHandler clientHandler;
                                if (sk.isWritable() && !NIOTcpMultiplexer.this.writeAndProcessChannelData(clientHandler = (NIOClientSocketHandler)sk.attachment())) {
                                    NIOTcpMultiplexer.this.dropClientHandler(clientHandler, NIOTcpMultiplexer.this.selector, true);
                                    continue;
                                }
                                if (sk.isReadable() && !NIOTcpMultiplexer.this.readAndProcessChannelData(clientHandler = (NIOClientSocketHandler)sk.attachment())) {
                                    NIOTcpMultiplexer.this.dropClientHandler(clientHandler, NIOTcpMultiplexer.this.selector, true);
                                    continue;
                                }
                                if (sk.isAcceptable()) {
                                    NIOServerSocketHandler serverHandler = (NIOServerSocketHandler)sk.attachment();
                                    ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                    SocketChannel clientChannel = nextReady.accept();
                                    clientChannel.configureBlocking(false);
                                    SocketUtils.setupSocket(clientChannel.socket(), NIOTcpMultiplexer.this.socketSendBufferSize, NIOTcpMultiplexer.this.socketRecvBufferSize);
                                    if (!NIOTcpMultiplexer.this.acceptClient(serverHandler, clientChannel)) {
                                        log.error((Object)"Dropping incoming connection due to errors ...");
                                        clientChannel.close();
                                        continue;
                                    }
                                }
                                if (!sk.isConnectable() || NIOTcpMultiplexer.this.finalizeConnect(clientHandler = (NIOClientSocketHandler)sk.attachment(), (SocketChannel)sk.channel(), NIOTcpMultiplexer.this.selector)) continue;
                                NIOTcpMultiplexer.this.dropClientHandler(clientHandler, NIOTcpMultiplexer.this.selector, true);
                            }
                            catch (CancelledKeyException e) {
                                Object attachement = sk.attachment();
                                if (attachement instanceof NIOClientSocketHandler) {
                                    NIOClientSocketHandler clientHandler = (NIOClientSocketHandler)attachement;
                                    log.debug((Object)("[" + clientHandler.getId() + "] Selection key cancelled, dropping cient ..."));
                                    NIOTcpMultiplexer.this.dropClientHandler(clientHandler, NIOTcpMultiplexer.this.selector, true);
                                    continue;
                                }
                                log.error((Object)"Server selection key was cancelled", (Throwable)e);
                            }
                        }
                    }
                    Object object = NIOTcpMultiplexer.this.pendingAcceptHandlers;
                    synchronized (object) {
                        if (NIOTcpMultiplexer.this.pendingAcceptHandlers.size() > 0) {
                            for (int i = 0; i < NIOTcpMultiplexer.this.pendingAcceptHandlers.size(); ++i) {
                                NIOServerSocketHandler serverHandler = NIOTcpMultiplexer.this.pendingAcceptHandlers.get(i);
                                NIOTcpMultiplexer.this.addInterest(serverHandler.getServerSocketChannel(), 16, serverHandler, NIOTcpMultiplexer.this.selector);
                                NIOTcpMultiplexer.this.serverHandlers.add(serverHandler);
                            }
                            NIOTcpMultiplexer.this.pendingAcceptHandlers.clear();
                        }
                    }
                    object = NIOTcpMultiplexer.this.clientHandlers;
                    synchronized (object) {
                        for (NIOClientSocketHandler clientHandler : NIOTcpMultiplexer.this.clientHandlers.values()) {
                            NIOTcpMultiplexer.this.updateConnectInterest(clientHandler, NIOTcpMultiplexer.this.selector);
                            NIOTcpMultiplexer.this.updateReadInterest(clientHandler, NIOTcpMultiplexer.this.selector);
                            NIOTcpMultiplexer.this.updateWriteInterest(clientHandler, NIOTcpMultiplexer.this.selector);
                        }
                    }
                }
                NIOTcpMultiplexer.this.selector.close();
            }
            catch (Throwable e) {
                log.error((Object)"Selector thread failed", e);
            }
            log.debug((Object)"Exiting");
        }
    }
}

