/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import net.timewalker.ffmq4.transport.packet.AbstractQueryPacket;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class CreateSessionQuery
extends AbstractQueryPacket {
    private IntegerID sessionId;
    private boolean transacted;
    private int acknowledgeMode;

    @Override
    public byte getType() {
        return 15;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        out.writeInt(this.sessionId.asInt());
        out.writeBoolean(this.transacted);
        out.writeInt(this.acknowledgeMode);
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        this.sessionId = new IntegerID(in.readInt());
        this.transacted = in.readBoolean();
        this.acknowledgeMode = in.readInt();
    }

    public void setSessionId(IntegerID sessionId) {
        this.sessionId = sessionId;
    }

    public IntegerID getSessionId() {
        return this.sessionId;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" sessionId=");
        sb.append(this.sessionId);
        sb.append(" transacted=");
        sb.append(this.transacted);
        sb.append(" acknowledgeMode=");
        sb.append(this.acknowledgeMode);
        return sb.toString();
    }
}

