/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import javax.jms.Destination;
import javax.jms.Queue;
import net.timewalker.ffmq4.common.destination.DestinationSerializer;
import net.timewalker.ffmq4.transport.packet.query.AbstractSessionQuery;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class CreateBrowserQuery
extends AbstractSessionQuery {
    private IntegerID browserId;
    private Queue queue;
    private String messageSelector;

    @Override
    public byte getType() {
        return 41;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        out.writeInt(this.browserId.asInt());
        DestinationSerializer.serializeTo((Destination)this.queue, out);
        out.writeNullableUTF(this.messageSelector);
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        this.browserId = new IntegerID(in.readInt());
        this.queue = (Queue)DestinationSerializer.unserializeFrom(in);
        this.messageSelector = in.readNullableUTF();
    }

    public IntegerID getBrowserId() {
        return this.browserId;
    }

    public void setBrowserId(IntegerID browserId) {
        this.browserId = browserId;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" browserId=");
        sb.append(this.browserId);
        sb.append(" queue=");
        sb.append(this.queue);
        sb.append(" messageSelector=[");
        sb.append(this.messageSelector);
        sb.append("]");
        return sb.toString();
    }
}

