/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import java.util.ArrayList;
import java.util.List;
import net.timewalker.ffmq4.transport.packet.query.AbstractSessionQuery;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public abstract class AbstractTransactionDemarcationQuery
extends AbstractSessionQuery {
    private List<String> deliveredMessageIDs;

    public List<String> getDeliveredMessageIDs() {
        return this.deliveredMessageIDs;
    }

    public void setDeliveredMessageIDs(List<String> deliveredMessageIDs) {
        this.deliveredMessageIDs = deliveredMessageIDs;
    }

    public void addDeliveredMessageID(String msgID) {
        if (this.deliveredMessageIDs == null) {
            this.deliveredMessageIDs = new ArrayList<String>();
        }
        this.deliveredMessageIDs.add(msgID);
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        if (this.deliveredMessageIDs != null) {
            int len = this.deliveredMessageIDs.size();
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                out.writeUTF(this.deliveredMessageIDs.get(i));
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        int idCount = in.readInt();
        for (int i = 0; i < idCount; ++i) {
            String msgID = in.readUTF();
            this.addDeliveredMessageID(msgID);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" ids=");
        sb.append(this.deliveredMessageIDs != null ? this.deliveredMessageIDs.size() : 0);
        return sb.toString();
    }
}

