/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet;

import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageSerializer;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class NotificationPacket
extends AbstractPacket {
    private IntegerID sessionId;
    private IntegerID consumerId;
    private AbstractMessage message;
    private boolean donePrefetching;

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        out.writeInt(this.sessionId.asInt());
        out.writeInt(this.consumerId.asInt());
        MessageSerializer.serializeTo(this.message, out);
        out.writeBoolean(this.donePrefetching);
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        this.sessionId = new IntegerID(in.readInt());
        this.consumerId = new IntegerID(in.readInt());
        this.message = MessageSerializer.unserializeFrom(in, false);
        this.donePrefetching = in.readBoolean();
    }

    public IntegerID getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(IntegerID sessionId) {
        this.sessionId = sessionId;
    }

    public IntegerID getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(IntegerID consumerId) {
        this.consumerId = consumerId;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public boolean isDonePrefetching() {
        return this.donePrefetching;
    }

    public void setDonePrefetching(boolean donePrefetching) {
        this.donePrefetching = donePrefetching;
    }

    @Override
    public final boolean isResponseExpected() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" consumerId=");
        sb.append(this.consumerId);
        sb.append(" message=");
        sb.append(this.message.getJMSMessageID());
        sb.append(" donePrefetching=");
        sb.append(this.donePrefetching);
        return sb.toString();
    }
}

