/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport;

import java.net.URI;
import net.timewalker.ffmq4.client.ClientEnvironment;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketTransport;
import net.timewalker.ffmq4.transport.tcp.nio.NIOTcpPacketTransport;
import net.timewalker.ffmq4.utils.Settings;

public class PacketTransportFactory {
    private static PacketTransportFactory instance = null;

    public static synchronized PacketTransportFactory getInstance() {
        if (instance == null) {
            instance = new PacketTransportFactory();
        }
        return instance;
    }

    private PacketTransportFactory() {
    }

    public PacketTransport createPacketTransport(String id, URI transportURI, Settings settings) throws PacketTransportException {
        String protocol = transportURI.getScheme();
        if (protocol == null) {
            protocol = "tcp";
        }
        if (protocol.equals("tcp") || protocol.equals("tcps")) {
            return new TcpPacketTransport(id, transportURI, settings);
        }
        if (protocol.equals("tcpnio")) {
            return new NIOTcpPacketTransport(id, ClientEnvironment.getMultiplexer(), transportURI, settings);
        }
        throw new PacketTransportException("Unsupported transport protocol : " + protocol);
    }
}

