/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.client.ClientEnvironment;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.PacketTransportHub;
import net.timewalker.ffmq4.transport.packet.AbstractQueryPacket;
import net.timewalker.ffmq4.transport.packet.AbstractResponsePacket;
import net.timewalker.ffmq4.transport.packet.response.ErrorResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PacketTransportEndpoint {
    protected static final Log log = LogFactory.getLog(PacketTransportEndpoint.class);
    private int id;
    private String fullId;
    private PacketTransportHub parentHub;
    private int transportTimeout;
    private Semaphore responseSemaphore = new Semaphore(0);
    private AbstractResponsePacket response;
    private boolean traceEnabled;

    public PacketTransportEndpoint(int id, PacketTransportHub parentHub) {
        this.id = id;
        this.parentHub = parentHub;
        this.fullId = parentHub.getTransport().getId() + "-" + id;
        this.traceEnabled = log.isTraceEnabled();
        this.transportTimeout = ClientEnvironment.getSettings().getIntProperty("transport.timeout", 30);
    }

    public int getId() {
        return this.id;
    }

    protected Semaphore getResponseSemaphore() {
        return this.responseSemaphore;
    }

    protected void setResponse(AbstractResponsePacket response) {
        this.response = response;
    }

    public synchronized AbstractResponsePacket blockingRequest(AbstractQueryPacket query) throws JMSException {
        int n;
        this.response = null;
        query.setEndpointId(this.id);
        if (this.traceEnabled) {
            log.trace((Object)("[" + this.fullId + "] blockingRequest() : Sending " + query));
        }
        PacketTransport transport = this.parentHub.getTransport();
        try {
            transport.send(query);
        }
        catch (PacketTransportException e) {
            throw new FFMQException("[" + this.fullId + "] Could not send packet on transport : " + e.toString(), "TRANSPORT_ERROR");
        }
        for (n = 0; n < this.transportTimeout; ++n) {
            try {
                if (this.responseSemaphore.tryAcquire(1L, TimeUnit.SECONDS)) break;
                if (!transport.isClosed()) continue;
            }
            catch (InterruptedException e) {}
            break;
        }
        AbstractResponsePacket receivedResponse = this.response;
        this.response = null;
        if (n == this.transportTimeout) {
            throw new FFMQException("[" + this.fullId + "] Timeout waiting for server response (" + this.transportTimeout + "s)", "TRANSPORT_ERROR");
        }
        if (receivedResponse == null) {
            throw new FFMQException("[" + this.fullId + "] Could not get an answer from server (Transport was closed after " + n + "s)", "TRANSPORT_ERROR");
        }
        if (receivedResponse instanceof ErrorResponse) {
            ((ErrorResponse)receivedResponse).respawnError();
        }
        if (this.traceEnabled) {
            log.trace((Object)("[" + this.fullId + "] blockingRequest() : Received " + receivedResponse));
        }
        return receivedResponse;
    }

    public void nonBlockingRequest(AbstractQueryPacket query) throws JMSException {
        if (this.parentHub.getTransport().needsThrottling()) {
            if (this.traceEnabled) {
                log.trace((Object)"Send queue is too big, throttling down ...");
            }
            this.blockingRequest(query);
            return;
        }
        query.setEndpointId(-1);
        if (this.traceEnabled) {
            log.trace((Object)("[" + this.fullId + "] nonBlockingRequest() : Sending " + query));
        }
        try {
            this.parentHub.getTransport().send(query);
        }
        catch (PacketTransportException e) {
            throw new FFMQException("[" + this.fullId + "] Could not send packet on transport : " + e.toString(), "TRANSPORT_ERROR");
        }
    }

    public void close() {
        this.parentHub.unregisterEndpoint(this);
    }
}

