/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.message.impl;

import javax.jms.JMSException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.storage.data.LinkedDataStore;
import net.timewalker.ffmq4.storage.data.impl.InMemoryLinkedDataStore;
import net.timewalker.ffmq4.storage.message.impl.AbstractMessageStore;

public final class InMemoryMessageStore
extends AbstractMessageStore {
    public InMemoryMessageStore(QueueDefinition queueDef) {
        super(queueDef);
    }

    @Override
    protected LinkedDataStore createDataStore() {
        int maxSize = this.queueDef.getMaxNonPersistentMessages();
        return new InMemoryLinkedDataStore(this.queueDef.getName() + " Volatile Store", Math.min(maxSize, 16), maxSize);
    }

    @Override
    public int getDeliveryMode() {
        return 1;
    }

    @Override
    protected AbstractMessage retrieveMessage(int handle) throws JMSException {
        return (AbstractMessage)((InMemoryLinkedDataStore)this.dataStore).retrieve(handle);
    }

    @Override
    protected int retrieveMessagePriority(int handle) throws JMSException {
        return this.retrieveMessage(handle).getJMSPriority();
    }

    @Override
    protected int storeMessage(AbstractMessage message, int previousHandle) throws JMSException {
        return ((InMemoryLinkedDataStore)this.dataStore).store(message, previousHandle);
    }

    @Override
    protected int replaceMessage(int handle, AbstractMessage message) throws JMSException {
        return ((InMemoryLinkedDataStore)this.dataStore).replace(handle, message);
    }

    @Override
    public void delete() throws JMSException {
    }

    @Override
    public boolean isFailSafe() {
        return false;
    }
}

