/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.message.impl;

import javax.jms.JMSException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageSerializer;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.storage.data.LinkedDataStore;
import net.timewalker.ffmq4.storage.data.impl.AbstractBlockBasedDataStore;
import net.timewalker.ffmq4.storage.data.impl.BlockBasedDataStore;
import net.timewalker.ffmq4.storage.data.impl.BlockBasedDataStoreTools;
import net.timewalker.ffmq4.storage.data.impl.JournalingBlockBasedDataStore;
import net.timewalker.ffmq4.storage.message.impl.AbstractMessageStore;
import net.timewalker.ffmq4.utils.async.AsyncTaskManager;

public final class BlockFileMessageStore
extends AbstractMessageStore {
    private AsyncTaskManager asyncTaskManager;
    private boolean useJournal;

    public BlockFileMessageStore(QueueDefinition queueDef, AsyncTaskManager asyncTaskManager) {
        super(queueDef);
        this.asyncTaskManager = asyncTaskManager;
        this.useJournal = queueDef.isUseJournal() && !queueDef.isTemporary();
    }

    @Override
    protected LinkedDataStore createDataStore() {
        if (this.useJournal) {
            return new JournalingBlockBasedDataStore(this.queueDef, this.asyncTaskManager);
        }
        return new BlockBasedDataStore(this.queueDef);
    }

    @Override
    public int getDeliveryMode() {
        return 2;
    }

    @Override
    protected AbstractMessage retrieveMessage(int handle) throws JMSException {
        byte[] rawMsg = (byte[])this.dataStore.retrieve(handle);
        return MessageSerializer.unserialize(rawMsg, true);
    }

    @Override
    protected int retrieveMessagePriority(int handle) throws JMSException {
        byte[] msgHeader = ((AbstractBlockBasedDataStore)this.dataStore).retrieveHeader(handle, 2);
        return msgHeader[1] & 0xF;
    }

    private byte[] serialize(AbstractMessage message) {
        return MessageSerializer.serialize(message, ((AbstractBlockBasedDataStore)this.dataStore).getBlockSize());
    }

    @Override
    protected int replaceMessage(int handle, AbstractMessage message) throws JMSException {
        return this.dataStore.replace(handle, this.serialize(message));
    }

    @Override
    protected int storeMessage(AbstractMessage message, int previousHandle) throws JMSException {
        return this.dataStore.store(this.serialize(message), previousHandle);
    }

    @Override
    public void delete() throws JMSException {
        BlockBasedDataStoreTools.delete(this.queueDef.getName(), this.queueDef.getDataFolder(), false);
    }

    @Override
    public boolean isFailSafe() {
        return this.useJournal;
    }
}

