/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;

public final class StoreExtendOperation
extends AbstractJournalOperation {
    private static final byte[] EMPTY_ALLOCATION_BLOCK = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int blockSize;
    private int oldBlockCount;
    private int newBlockCount;

    public StoreExtendOperation(long transactionId, int blockSize, int oldBlockCount, int newBlockCount) {
        super(transactionId, (byte)4);
        this.blockSize = blockSize;
        this.oldBlockCount = oldBlockCount;
        this.newBlockCount = newBlockCount;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getOldBlockCount() {
        return this.oldBlockCount;
    }

    public int getNewBlockCount() {
        return this.newBlockCount;
    }

    @Override
    public int size() {
        return super.size() + 4 + 4 + 4;
    }

    @Override
    protected void writeTo(JournalFile journalFile) throws JournalException {
        super.writeTo(journalFile);
        journalFile.writeInt(this.blockSize);
        journalFile.writeInt(this.oldBlockCount);
        journalFile.writeInt(this.newBlockCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int extend(RandomAccessFile allocationTableRandomAccessFile, RandomAccessFile dataRandomAccessFile) throws JournalException {
        try {
            allocationTableRandomAccessFile.setLength(12L + (long)this.newBlockCount * 13L);
            allocationTableRandomAccessFile.seek(12 + this.oldBlockCount * 13);
            for (int n = this.oldBlockCount; n < this.newBlockCount; ++n) {
                allocationTableRandomAccessFile.write(EMPTY_ALLOCATION_BLOCK);
            }
            allocationTableRandomAccessFile.seek(0L);
            allocationTableRandomAccessFile.writeInt(this.newBlockCount);
            RandomAccessFile n = dataRandomAccessFile;
            synchronized (n) {
                dataRandomAccessFile.setLength((long)this.blockSize * (long)this.newBlockCount);
            }
        }
        catch (IOException e) {
            throw new JournalException("Cannot write to store allocation table file", e);
        }
        return this.newBlockCount;
    }

    @Override
    public String toString() {
        return super.toString() + " [STORE_EXTEND] blockSize=" + this.blockSize + " oldBlockCount=" + this.oldBlockCount + " newBlockCount=" + this.newBlockCount;
    }
}

