/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.util.HashMap;
import java.util.Map;

public final class DirtyBlockTable {
    private Map<Integer, DirtyBlockEntry> dirtyBlocksMap = new HashMap<Integer, DirtyBlockEntry>();
    private int size;

    public synchronized void markDirty(int blockIndex, byte[] blockData) {
        Integer key = blockIndex;
        DirtyBlockEntry entry = this.dirtyBlocksMap.get(key);
        if (entry == null) {
            entry = new DirtyBlockEntry();
            entry.modCount = 1;
            this.dirtyBlocksMap.put(key, entry);
        } else {
            ++entry.modCount;
        }
        entry.latestData = blockData;
        ++this.size;
    }

    public synchronized void blockFlushed(int blockIndex) {
        Integer key = blockIndex;
        DirtyBlockEntry entry = this.dirtyBlocksMap.get(key);
        if (entry == null) {
            throw new IllegalArgumentException("Not a dirty block : " + blockIndex);
        }
        --entry.modCount;
        if (entry.modCount == 0) {
            this.dirtyBlocksMap.remove(key);
        }
        --this.size;
    }

    public synchronized byte[] get(int blockIndex) {
        Integer key = blockIndex;
        DirtyBlockEntry entry = this.dirtyBlocksMap.get(key);
        return entry != null ? entry.latestData : null;
    }

    public int getSize() {
        return this.size;
    }

    private static final class DirtyBlockEntry {
        protected int modCount;
        protected byte[] latestData;

        protected DirtyBlockEntry() {
        }
    }
}

