/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.timewalker.ffmq4.management.destination.AbstractDestinationDescriptor;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.impl.AbstractBlockBasedDataStore;
import net.timewalker.ffmq4.storage.data.impl.BlockBasedDataStoreTools;
import net.timewalker.ffmq4.storage.data.impl.journal.BlockBasedDataStoreJournal;
import net.timewalker.ffmq4.storage.data.impl.journal.DirtyBlockTable;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalRecovery;
import net.timewalker.ffmq4.utils.async.AsyncTaskManager;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JournalingBlockBasedDataStore
extends AbstractBlockBasedDataStore {
    private static final Log log = LogFactory.getLog(JournalingBlockBasedDataStore.class);
    private AsyncTaskManager asyncTaskManager;
    private BlockBasedDataStoreJournal journal;
    private DirtyBlockTable dirtyBlockTable = new DirtyBlockTable();
    private boolean keepJournalFiles = System.getProperty("ffmq.dataStore.keepJournalFiles", "false").equals("true");

    public JournalingBlockBasedDataStore(AbstractDestinationDescriptor descriptor, AsyncTaskManager asyncTaskManager) {
        super(descriptor);
        this.asyncTaskManager = asyncTaskManager;
    }

    @Override
    protected void initFilesystem() throws DataStoreException {
        super.initFilesystem();
        String baseName = this.descriptor.getName();
        File dataFolder = this.descriptor.getDataFolder();
        File[] oldRecycledFiles = BlockBasedDataStoreTools.findRecycledJournalFiles(baseName, dataFolder);
        for (int i = 0; i < oldRecycledFiles.length; ++i) {
            if (oldRecycledFiles[i].delete()) continue;
            throw new DataStoreException("Cannot delete recycled journal file : " + oldRecycledFiles[i].getAbsolutePath());
        }
        File[] journalFiles = BlockBasedDataStoreTools.findJournalFiles(baseName, dataFolder);
        if (journalFiles.length > 0) {
            JournalRecovery recovery = new JournalRecovery(baseName, journalFiles, this.allocationTableRandomAccessFile, this.dataRandomAccessFile);
            int newBlockCount = recovery.recover();
            if (newBlockCount != -1) {
                this.blockCount = newBlockCount;
            }
            if (!this.keepJournalFiles) {
                for (int i = 0; i < journalFiles.length; ++i) {
                    if (journalFiles[i].delete()) continue;
                    throw new DataStoreException("Cannot delete journal file : " + journalFiles[i].getAbsolutePath());
                }
            }
            log.warn((Object)("[" + baseName + "] Forcing integrity check after journal recovery ..."));
            this.integrityCheck();
            log.warn((Object)("[" + baseName + "] Check complete."));
        }
        this.journal = new BlockBasedDataStoreJournal(baseName, this.descriptor.getJournalFolder(), this.descriptor.getMaxJournalSize(), this.descriptor.getMaxWriteBatchSize(), this.descriptor.getMaxUnflushedJournalSize(), this.descriptor.getMaxUncommittedStoreSize(), this.descriptor.getJournalOutputBuffer(), this.descriptor.getStorageSyncMethod(), this.descriptor.isPreAllocateFiles(), this.allocationTableRandomAccessFile, this.dataRandomAccessFile, this.dirtyBlockTable, this.asyncTaskManager);
    }

    @Override
    protected void writeFirstBlock() throws DataStoreException {
        this.journal.writeMetaData(8L, this.firstBlock);
    }

    @Override
    protected void writeAllocationBlock(int blockIndex) throws DataStoreException {
        byte[] allocationBlock = this.serializeAllocationBlock(blockIndex);
        this.journal.writeMetaDataBlock(12 + blockIndex * 13, allocationBlock);
    }

    @Override
    protected void writeDataBlock(byte[] data, int offset, int len, int blockHandle) throws DataStoreException {
        byte[] blockData = new byte[this.blockSize];
        System.arraycopy(data, offset, blockData, 0, len);
        this.dirtyBlockTable.markDirty(blockHandle, blockData);
        this.journal.writeDataBlock(blockHandle, (long)blockHandle * (long)this.blockSize, blockData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readDataBlock(byte[] data, int offset, int len, int blockHandle) throws DataStoreException {
        byte[] dirtyBlock = this.dirtyBlockTable.get(blockHandle);
        if (dirtyBlock != null) {
            System.arraycopy(dirtyBlock, 0, data, offset, len);
        } else {
            try {
                long dataOffset = (long)blockHandle * (long)this.blockSize;
                RandomAccessFile randomAccessFile = this.dataRandomAccessFile;
                synchronized (randomAccessFile) {
                    this.dataRandomAccessFile.seek(dataOffset);
                    if (this.dataRandomAccessFile.read(data, offset, len) != len) {
                        throw new DataStoreException("Cannot read " + len + " bytes from store file");
                    }
                }
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (IOException e) {
                throw new DataStoreException("Could not read data block " + blockHandle, e);
            }
        }
    }

    @Override
    protected void extendStoreFiles(int oldBlockCount, int newBlockCount) throws DataStoreException {
        this.journal.extendStore(this.blockSize, oldBlockCount, newBlockCount);
    }

    @Override
    protected void flush() throws DataStoreException {
        this.journal.flush();
    }

    @Override
    public void commitChanges(SynchronizationBarrier barrier) throws DataStoreException {
        this.journal.commit(barrier);
    }

    @Override
    public void commitChanges() throws DataStoreException {
        try {
            SynchronizationBarrier barrier = new SynchronizationBarrier();
            this.journal.commit(barrier);
            barrier.waitFor();
        }
        catch (InterruptedException e) {
            throw new DataStoreException("Wait for commit barrier was interrupted");
        }
    }

    @Override
    public void close() {
        try {
            this.commitChanges();
            this.journal.close();
        }
        catch (DataStoreException e) {
            log.error((Object)("[" + this.descriptor.getName() + "] Could not properly close store journal"), (Throwable)((Object)e));
        }
        super.close();
    }
}

