/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl;

import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.impl.AbstractDataStore;
import net.timewalker.ffmq4.utils.FastBitSet;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;

public final class InMemoryLinkedDataStore
extends AbstractDataStore {
    private String name;
    private int maxSize;
    private int[] nextEntry;
    private int[] previousEntry;
    private int firstEntry;
    private Object[] data;
    private int size;
    private int lastEmpty;

    public InMemoryLinkedDataStore(String name, int initialSize, int maxSize) {
        this.name = name;
        this.maxSize = maxSize;
        this.nextEntry = new int[initialSize];
        this.previousEntry = new int[initialSize];
        this.firstEntry = -1;
        this.data = new Object[initialSize];
        this.locks = new FastBitSet(initialSize);
    }

    @Override
    public void init() throws DataStoreException {
    }

    private boolean reallocate() throws DataStoreException {
        int actualSize = this.data.length;
        if (actualSize >= this.maxSize) {
            return false;
        }
        int newSize = Math.min(actualSize * 2, this.maxSize);
        try {
            int[] newNextEntry = new int[newSize];
            int[] newPreviousEntry = new int[newSize];
            Object[] newData = new Object[newSize];
            System.arraycopy(this.nextEntry, 0, newNextEntry, 0, actualSize);
            System.arraycopy(this.previousEntry, 0, newPreviousEntry, 0, actualSize);
            System.arraycopy(this.data, 0, newData, 0, actualSize);
            this.nextEntry = newNextEntry;
            this.previousEntry = newPreviousEntry;
            this.data = newData;
            this.locks.ensureCapacity(newSize);
        }
        catch (OutOfMemoryError e) {
            throw new DataStoreException("[" + this.name + "] Cannot extend in-memory datastore to " + newSize);
        }
        return true;
    }

    @Override
    protected void checkHandle(int handle) throws DataStoreException {
        if (handle < 0 || handle >= this.data.length || this.data[handle] == null) {
            throw new DataStoreException(this.name + " : Invalid handle : " + handle);
        }
    }

    private int findEmpty() {
        int pos = this.lastEmpty;
        for (int n = 0; n < this.data.length; ++n) {
            if (pos >= this.data.length) {
                pos = 0;
            }
            if (this.data[pos] == null) {
                this.lastEmpty = pos + 1;
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public Object retrieve(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        return this.data[handle];
    }

    @Override
    public int replace(int handle, Object obj) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        this.data[handle] = obj;
        return handle;
    }

    @Override
    public int store(Object obj, int previousHandle) throws DataStoreException {
        int nextHandle;
        if (this.data.length == this.size && !this.reallocate()) {
            return -1;
        }
        if (previousHandle != -1) {
            if (SAFE_MODE) {
                this.checkHandle(previousHandle);
            }
            nextHandle = this.nextEntry[previousHandle];
        } else {
            nextHandle = this.firstEntry;
        }
        int newHandle = this.findEmpty();
        if (newHandle == -1) {
            return -1;
        }
        this.previousEntry[newHandle] = previousHandle;
        this.nextEntry[newHandle] = nextHandle;
        this.data[newHandle] = obj;
        if (previousHandle != -1) {
            this.nextEntry[previousHandle] = newHandle;
        }
        if (nextHandle != -1) {
            this.previousEntry[nextHandle] = newHandle;
        }
        if (previousHandle == -1) {
            this.firstEntry = newHandle;
        }
        ++this.size;
        return newHandle;
    }

    @Override
    public int delete(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        int previousHandle = this.previousEntry[handle];
        int nextHandle = this.nextEntry[handle];
        if (previousHandle != -1) {
            this.nextEntry[previousHandle] = nextHandle;
        }
        if (nextHandle != -1) {
            this.previousEntry[nextHandle] = previousHandle;
        }
        this.previousEntry[handle] = -1;
        this.nextEntry[handle] = -1;
        this.data[handle] = null;
        this.locks.clear(handle);
        if (this.firstEntry == handle) {
            this.firstEntry = nextHandle;
        }
        --this.size;
        return previousHandle;
    }

    @Override
    public int first() throws DataStoreException {
        return this.firstEntry;
    }

    @Override
    public int next(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        return this.nextEntry[handle];
    }

    @Override
    public int previous(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        return this.previousEntry[handle];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void commitChanges(SynchronizationBarrier barrier) throws DataStoreException {
    }

    @Override
    public void commitChanges() throws DataStoreException {
    }

    @Override
    public void close() {
    }

    @Override
    public int getStoreUsage() {
        long ratio = this.maxSize > 0 ? (long)this.size * 100L / (long)this.maxSize : 0L;
        return (int)ratio;
    }

    @Override
    public int getAbsoluteStoreUsage() {
        return this.getStoreUsage();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Allocation Table (size=" + this.size + ")\n");
        sb.append("------------------------------------\n");
        sb.append("first entry index : ");
        sb.append(this.firstEntry);
        sb.append("\n");
        for (int n = 0; n < this.data.length; ++n) {
            sb.append(n);
            sb.append(": ");
            if (this.data[n] == null) {
                sb.append("(free)\n");
                continue;
            }
            sb.append(this.previousEntry[n]);
            sb.append("\t");
            sb.append(this.nextEntry[n]);
            sb.append("\t");
            sb.append(this.data[n]);
            sb.append("\n");
        }
        sb.append("------------------------------------\n");
        return sb.toString();
    }
}

