/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl;

import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.LinkedDataStore;
import net.timewalker.ffmq4.utils.FastBitSet;

public abstract class AbstractDataStore
implements LinkedDataStore {
    protected static final boolean SAFE_MODE = System.getProperty("ffmq.dataStore.safeMode", "false").equals("true");
    protected FastBitSet locks;

    protected abstract void checkHandle(int var1) throws DataStoreException;

    @Override
    public final boolean isLocked(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        return this.locks.get(handle);
    }

    @Override
    public final void lock(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        if (!this.locks.flip(handle)) {
            this.locks.flip(handle);
            throw new DataStoreException("Handle already locked : " + handle);
        }
    }

    @Override
    public final void unlock(int handle) throws DataStoreException {
        if (SAFE_MODE) {
            this.checkHandle(handle);
        }
        if (this.locks.flip(handle)) {
            this.locks.flip(handle);
            throw new DataStoreException("Handle was not locked : " + handle);
        }
    }
}

