/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.security;

import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.FFMQEngineSetup;
import net.timewalker.ffmq4.security.SecurityConnector;
import net.timewalker.ffmq4.utils.Settings;

public final class SecurityConnectorProvider {
    private static SecurityConnector connector;

    public static synchronized SecurityConnector getConnector(FFMQEngineSetup setup) throws JMSException {
        if (connector == null) {
            String connectorType = setup.getSecurityConnectorType();
            try {
                Class<?> connectorClass = Class.forName(connectorType);
                connector = (SecurityConnector)connectorClass.getConstructor(Settings.class).newInstance(setup.getSettings());
            }
            catch (ClassNotFoundException e) {
                throw new FFMQException("Security connector class not found : " + connectorType, "SECURITY_ERROR", e);
            }
            catch (ClassCastException e) {
                throw new FFMQException("Invalid security connector class : " + connectorType, "SECURITY_ERROR", e);
            }
            catch (InstantiationException e) {
                throw new FFMQException("Cannot create security connector", "SECURITY_ERROR", e.getCause());
            }
            catch (InvocationTargetException e) {
                throw new FFMQException("Cannot create security connector", "SECURITY_ERROR", e.getTargetException());
            }
            catch (Exception e) {
                throw new FFMQException("Cannot create security connector", "SECURITY_ERROR", e);
            }
        }
        return connector;
    }
}

