/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.remote.session;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowser;
import net.timewalker.ffmq4.remote.session.RemoteQueueBrowserEnumeration;
import net.timewalker.ffmq4.remote.session.RemoteSession;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.transport.packet.query.CloseBrowserQuery;
import net.timewalker.ffmq4.transport.packet.query.CreateBrowserQuery;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteQueueBrowser
extends AbstractQueueBrowser {
    private static final Log log = LogFactory.getLog(RemoteQueueBrowser.class);
    protected final PacketTransportEndpoint transportEndpoint;

    public RemoteQueueBrowser(IntegerID browserId, RemoteSession session, Queue queue, String messageSelector) {
        super(session, queue, messageSelector, browserId);
        this.transportEndpoint = session.getTransportEndpoint();
        log.debug((Object)("Remote browser ID is " + browserId));
    }

    protected void remoteInit() throws JMSException {
        CreateBrowserQuery query = new CreateBrowserQuery();
        query.setBrowserId(this.id);
        query.setSessionId(this.session.getId());
        query.setQueue(this.queue);
        query.setMessageSelector(this.messageSelector);
        this.transportEndpoint.blockingRequest(query);
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkNotClosed();
        RemoteQueueBrowserEnumeration queueBrowserEnum = new RemoteQueueBrowserEnumeration((RemoteSession)this.session, this);
        queueBrowserEnum.remoteInit();
        this.registerEnumeration(queueBrowserEnum);
        return queueBrowserEnum;
    }

    @Override
    protected void onQueueBrowserClose() {
        super.onQueueBrowserClose();
        try {
            CloseBrowserQuery query = new CloseBrowserQuery();
            query.setSessionId(this.session.getId());
            query.setBrowserId(this.id);
            this.transportEndpoint.blockingRequest(query);
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }
}

