/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.remote.connection;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.Session;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.client.ClientEnvironment;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.remote.session.RemoteMessageConsumer;
import net.timewalker.ffmq4.remote.session.RemoteSession;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.PacketTransportFactory;
import net.timewalker.ffmq4.transport.PacketTransportHub;
import net.timewalker.ffmq4.transport.PacketTransportListener;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.packet.AbstractResponsePacket;
import net.timewalker.ffmq4.transport.packet.NotificationPacket;
import net.timewalker.ffmq4.transport.packet.query.DeleteTemporaryQueueQuery;
import net.timewalker.ffmq4.transport.packet.query.DeleteTemporaryTopicQuery;
import net.timewalker.ffmq4.transport.packet.query.OpenConnectionQuery;
import net.timewalker.ffmq4.transport.packet.query.RollbackMessageQuery;
import net.timewalker.ffmq4.transport.packet.query.SetClientIDQuery;
import net.timewalker.ffmq4.transport.packet.query.StartConnectionQuery;
import net.timewalker.ffmq4.transport.packet.query.StopConnectionQuery;
import net.timewalker.ffmq4.transport.packet.response.OpenConnectionResponse;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.async.AsyncTask;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConnection
extends AbstractConnection
implements PacketTransportListener {
    protected static final Log log = LogFactory.getLog(RemoteConnection.class);
    private URI transportURI;
    private PacketTransport transport;
    protected PacketTransportHub transportHub;
    protected PacketTransportEndpoint transportEndpoint;

    public RemoteConnection(URI transportURI, String userName, String password, String clientID) throws JMSException {
        super(clientID);
        this.transportURI = transportURI;
        try {
            this.connect(userName, password);
        }
        catch (JMSException e) {
            this.close();
            throw e;
        }
    }

    private void connect(String userName, String password) throws JMSException {
        log.debug((Object)("#" + this.id + " Creating transport"));
        try {
            this.transport = PacketTransportFactory.getInstance().createPacketTransport(this.id, this.transportURI, ClientEnvironment.getSettings());
            this.transport.setListener(this);
            this.transport.start();
        }
        catch (PacketTransportException e) {
            throw new FFMQException("Could not establish transport to " + this.transportURI, "TRANSPORT_ERROR", (Throwable)((Object)e));
        }
        this.transportHub = new PacketTransportHub(this.transport);
        this.transportEndpoint = this.transportHub.createEndpoint();
        log.debug((Object)("#" + this.id + " Opening connection context"));
        OpenConnectionQuery query = new OpenConnectionQuery();
        query.setUserName(userName);
        query.setPassword(password);
        query.setClientID(this.clientID);
        OpenConnectionResponse response = (OpenConnectionResponse)this.transportEndpoint.blockingRequest(query);
        if (response.getProtocolVersion() != 9) {
            throw new FFMQException("Transport protocol version mismatch (client is 9, server is " + response.getProtocolVersion() + ")", "PROTOCOL_MISMATCH");
        }
    }

    @Override
    public final void setClientID(String clientID) throws JMSException {
        super.setClientID(clientID);
        SetClientIDQuery query = new SetClientIDQuery();
        query.setClientID(clientID);
        this.transportEndpoint.blockingRequest(query);
    }

    @Override
    protected void onConnectionClose() {
        super.onConnectionClose();
        try {
            if (this.transport != null && !this.transport.isClosed()) {
                log.debug((Object)("#" + this.id + " Closing transport"));
                this.transport.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close transport", (Throwable)e);
        }
    }

    @Override
    protected void onConnectionClosed() {
        super.onConnectionClosed();
        if (this.transportHub != null) {
            this.transportHub.close();
        }
    }

    @Override
    public final void deleteTemporaryQueue(String queueName) throws JMSException {
        DeleteTemporaryQueueQuery query = new DeleteTemporaryQueueQuery();
        query.setQueueName(queueName);
        this.transportEndpoint.blockingRequest(query);
    }

    @Override
    public final void deleteTemporaryTopic(String topicName) throws JMSException {
        DeleteTemporaryTopicQuery query = new DeleteTemporaryTopicQuery();
        query.setTopicName(topicName);
        this.transportEndpoint.blockingRequest(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (!transacted && acknowledgeMode == 0) {
            throw new FFMQException("Acknowledge mode SESSION_TRANSACTED cannot be used for an non-transacted session", "INVALID_ACK_MODE");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteSession session = new RemoteSession(this.idProvider.createID(), this, this.transportHub.createEndpoint(), transacted, acknowledgeMode);
            this.registerSession(session);
            session.remoteInit();
            RemoteSession remoteSession = session;
            return remoteSession;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void start() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (this.started) {
                return;
            }
            this.started = true;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
        this.transportEndpoint.blockingRequest(new StartConnectionQuery());
    }

    public final void stop() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
        this.transportEndpoint.blockingRequest(new StopConnectionQuery());
        this.waitForDeliverySync();
    }

    @Override
    public final boolean packetReceived(AbstractPacket packet) {
        if (packet.getType() == 1) {
            NotificationPacket notifPacket = (NotificationPacket)packet;
            AbstractMessage prefetchedMessage = notifPacket.getMessage();
            boolean acceptedByConsumer = false;
            AbstractSession session = this.lookupRegisteredSession(notifPacket.getSessionId());
            if (session != null) {
                RemoteMessageConsumer consumer = (RemoteMessageConsumer)session.lookupRegisteredConsumer(notifPacket.getConsumerId());
                if (consumer != null) {
                    acceptedByConsumer = consumer.addToPrefetchQueue(prefetchedMessage, notifPacket.isDonePrefetching());
                } else {
                    log.debug((Object)("#" + this.id + " No such consumer : #" + notifPacket.getSessionId() + ":" + notifPacket.getConsumerId()));
                }
            } else {
                log.debug((Object)("#" + this.id + " No such session : #" + notifPacket.getSessionId()));
            }
            if (!acceptedByConsumer) {
                this.scheduleRollback(notifPacket.getSessionId(), notifPacket.getConsumerId(), prefetchedMessage);
            }
            return true;
        }
        if (packet.getType() == 60) {
            return true;
        }
        this.transportHub.routeResponse((AbstractResponsePacket)packet);
        return true;
    }

    private void scheduleRollback(final IntegerID sessionId, final IntegerID consumerId, AbstractMessage message) {
        try {
            final String messageId = message.getJMSMessageID();
            ClientEnvironment.getAsyncTaskManager().execute(new AsyncTask(){

                @Override
                public boolean isMergeable() {
                    return false;
                }

                @Override
                public void execute() {
                    RollbackMessageQuery query = new RollbackMessageQuery();
                    query.setSessionId(sessionId);
                    query.setConsumerId(consumerId);
                    query.setMessageId(messageId);
                    try {
                        RemoteConnection.this.transportEndpoint.blockingRequest(query);
                    }
                    catch (JMSException e) {
                        ErrorTools.log(e, log);
                    }
                }
            });
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }

    @Override
    public final void packetSent(AbstractPacket packet) {
    }

    @Override
    public final void transportClosed(boolean linkFailed, boolean mayBlock) {
        if (linkFailed) {
            this.close();
            if (mayBlock) {
                this.exceptionOccured(new FFMQException("Server connection lost", "NETWORK_FAILURE"));
            } else {
                try {
                    ClientEnvironment.getAsyncTaskManager().execute(new AsyncTask(){

                        @Override
                        public boolean isMergeable() {
                            return false;
                        }

                        @Override
                        public void execute() {
                            RemoteConnection.this.exceptionOccured(new FFMQException("Server connection lost", "NETWORK_FAILURE"));
                        }
                    });
                }
                catch (JMSException e) {
                    ErrorTools.log(e, log);
                }
            }
        }
    }
}

