/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.FFMQEngineSetup;
import net.timewalker.ffmq4.management.TemplateMapping;
import net.timewalker.ffmq4.utils.StringTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TemplateMappingProvider {
    private static final Log log = LogFactory.getLog(TemplateMappingProvider.class);
    private FFMQEngineSetup setup;
    private List<TemplateMapping> queueMappings = new Vector<TemplateMapping>();
    private List<TemplateMapping> topicMappings = new Vector<TemplateMapping>();

    public TemplateMappingProvider(FFMQEngineSetup setup) {
        this.setup = setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappings() throws JMSException {
        File mappingFile = this.setup.getTemplateMappingFile();
        if (mappingFile == null) {
            log.debug((Object)"Templates mapping file not defined, skipping.");
            return;
        }
        try (BufferedReader input = new BufferedReader(new FileReader(mappingFile));){
            String line;
            while ((line = input.readLine()) != null) {
                int commentSepIdx = line.indexOf(35);
                if (commentSepIdx != -1) {
                    line = line.substring(0, commentSepIdx);
                }
                if ((line = line.trim()).length() == 0) continue;
                String[] tokens = StringTools.split(line, ':');
                if (tokens.length != 3) {
                    throw new FFMQException("Invalid template mapping line : " + line, "INVALID_TEMPLATE_MAPPING");
                }
                boolean isQueueTemplate = tokens[0].equalsIgnoreCase("queue");
                String destinationNamePattern = tokens[1];
                String templateName = tokens[2];
                if (isQueueTemplate) {
                    this.addQueueTemplateMapping(new TemplateMapping(destinationNamePattern, templateName));
                    continue;
                }
                this.addTopicTemplateMapping(new TemplateMapping(destinationNamePattern, templateName));
            }
        }
        catch (IOException e) {
            throw new FFMQException("Cannot read templates mapping file", "FS_ERROR", e);
        }
    }

    public void addQueueTemplateMapping(TemplateMapping mappingEntry) {
        this.queueMappings.add(mappingEntry);
    }

    public void addTopicTemplateMapping(TemplateMapping mappingEntry) {
        this.topicMappings.add(mappingEntry);
    }

    public String getTemplateNameForQueue(String queueName) {
        for (int i = 0; i < this.queueMappings.size(); ++i) {
            TemplateMapping mapping = this.queueMappings.get(i);
            if (!StringTools.matches(queueName, mapping.getPattern())) continue;
            log.debug((Object)("Matching template for queue " + queueName + " : " + mapping.getTemplateName()));
            return mapping.getTemplateName();
        }
        log.debug((Object)("No matching template for queue " + queueName));
        return null;
    }

    public String getTemplateNameForTopic(String topicName) {
        for (int i = 0; i < this.topicMappings.size(); ++i) {
            TemplateMapping mapping = this.topicMappings.get(i);
            if (!StringTools.matches(topicName, mapping.getPattern())) continue;
            log.debug((Object)("Matching template for topic " + topicName + " : " + mapping.getTemplateName()));
            return mapping.getTemplateName();
        }
        log.debug((Object)("No matching template for topic " + topicName));
        return null;
    }
}

