/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.AbstractDefinitionProvider;
import net.timewalker.ffmq4.management.DescriptorTools;
import net.timewalker.ffmq4.management.FFMQEngineSetup;
import net.timewalker.ffmq4.management.destination.template.QueueTemplate;
import net.timewalker.ffmq4.management.destination.template.TopicTemplate;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DestinationTemplateProvider
extends AbstractDefinitionProvider {
    private static final Log log = LogFactory.getLog(DestinationTemplateProvider.class);
    private Map<String, QueueTemplate> queueTemplates = new Hashtable<String, QueueTemplate>();
    private Map<String, TopicTemplate> topicTemplates = new Hashtable<String, TopicTemplate>();

    public DestinationTemplateProvider(FFMQEngineSetup setup) {
        super(setup);
    }

    public void loadExistingTemplates() throws JMSException {
        File templatesDir = this.setup.getTemplatesDir();
        if (templatesDir != null) {
            log.info((Object)("Loading existing templates from : " + templatesDir.getAbsolutePath()));
            File[] queueTemplateDescriptors = DescriptorTools.getDescriptorFiles(templatesDir, "queueTemplate-", ".properties");
            if (queueTemplateDescriptors != null) {
                for (int i = 0; i < queueTemplateDescriptors.length; ++i) {
                    QueueTemplate queueTemplate = this.loadQueueTemplate(queueTemplateDescriptors[i]);
                    this.addQueueTemplate(queueTemplate);
                }
            }
            log.debug((Object)("Loaded " + this.queueTemplates.size() + " queue templates"));
            File[] topicTemplateDescriptors = DescriptorTools.getDescriptorFiles(templatesDir, "topicTemplate-", ".properties");
            if (topicTemplateDescriptors != null) {
                for (int i = 0; i < topicTemplateDescriptors.length; ++i) {
                    TopicTemplate topicTemplate = this.loadTopicTemplate(topicTemplateDescriptors[i]);
                    this.addTopicTemplate(topicTemplate);
                }
            }
            log.debug((Object)("Loaded " + this.topicTemplates.size() + " topic templates"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueTemplate(QueueTemplate queueTemplate) throws JMSException {
        queueTemplate.check();
        Map<String, QueueTemplate> map = this.queueTemplates;
        synchronized (map) {
            if (this.queueTemplates.containsKey(queueTemplate.getName())) {
                throw new FFMQException("Queue template name already used : " + queueTemplate.getName(), "DUPLICATE_QUEUE_TEMPLATE");
            }
            this.queueTemplates.put(queueTemplate.getName(), queueTemplate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTopicTemplate(TopicTemplate topicTemplate) throws JMSException {
        topicTemplate.check();
        Map<String, TopicTemplate> map = this.topicTemplates;
        synchronized (map) {
            if (this.topicTemplates.containsKey(topicTemplate.getName())) {
                throw new FFMQException("Topic template name already used : " + topicTemplate.getName(), "DUPLICATE_TOPIC_TEMPLATE");
            }
            this.topicTemplates.put(topicTemplate.getName(), topicTemplate);
        }
    }

    public QueueTemplate getQueueTemplate(String queueName) throws JMSException {
        QueueTemplate queueDef = this.queueTemplates.get(queueName);
        if (queueDef == null) {
            queueDef = this.loadQueueTemplate(queueName);
            if (queueDef == null) {
                return null;
            }
            this.queueTemplates.put(queueName, queueDef);
        }
        return queueDef;
    }

    private QueueTemplate loadQueueTemplate(String queueName) throws JMSException {
        if (this.setup.getTemplatesDir() == null) {
            return null;
        }
        return this.loadQueueTemplate(new File(this.setup.getTemplatesDir(), "queue-" + queueName + ".properties"));
    }

    private QueueTemplate loadQueueTemplate(File queueTemplateDescriptor) throws JMSException {
        if (!queueTemplateDescriptor.exists()) {
            return null;
        }
        if (!queueTemplateDescriptor.canRead()) {
            throw new FFMQException("Cannot access queue template descriptor : " + queueTemplateDescriptor.getAbsolutePath(), "FS_ERROR");
        }
        Settings queueSettings = new Settings();
        queueSettings.readFrom(queueTemplateDescriptor);
        return new QueueTemplate(queueSettings);
    }

    public TopicTemplate getTopicTemplate(String topicName) throws JMSException {
        TopicTemplate topicDef = this.topicTemplates.get(topicName);
        if (topicDef == null) {
            topicDef = this.loadTopicTemplate(topicName);
            if (topicDef == null) {
                return null;
            }
            this.topicTemplates.put(topicName, topicDef);
        }
        return topicDef;
    }

    private TopicTemplate loadTopicTemplate(String topicName) throws JMSException {
        if (this.setup.getTemplatesDir() == null) {
            return null;
        }
        return this.loadTopicTemplate(new File(this.setup.getTemplatesDir(), "topic-" + topicName + ".properties"));
    }

    private TopicTemplate loadTopicTemplate(File topicTemplateDescriptor) throws JMSException {
        if (!topicTemplateDescriptor.exists()) {
            return null;
        }
        if (!topicTemplateDescriptor.canRead()) {
            throw new FFMQException("Cannot access topic template descriptor : " + topicTemplateDescriptor.getAbsolutePath(), "FS_ERROR");
        }
        Settings topicSettings = new Settings();
        topicSettings.readFrom(topicTemplateDescriptor);
        return new TopicTemplate(topicSettings);
    }

    public void clear() {
        this.queueTemplates.clear();
        this.topicTemplates.clear();
    }
}

