/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.AbstractDefinitionProvider;
import net.timewalker.ffmq4.management.DescriptorTools;
import net.timewalker.ffmq4.management.FFMQEngineSetup;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DestinationDefinitionProvider
extends AbstractDefinitionProvider {
    private static final Log log = LogFactory.getLog(DestinationDefinitionProvider.class);
    private Map<String, QueueDefinition> queueDefinitions = new Hashtable<String, QueueDefinition>();
    private Map<String, TopicDefinition> topicDefinitions = new Hashtable<String, TopicDefinition>();

    public DestinationDefinitionProvider(FFMQEngineSetup setup) {
        super(setup);
    }

    public void loadExistingDefinitions() throws JMSException {
        File definitionDir = this.setup.getDestinationDefinitionsDir();
        if (definitionDir != null) {
            log.info((Object)("Loading existing destinations definitions from : " + definitionDir.getAbsolutePath()));
            File[] queueDescriptors = DescriptorTools.getDescriptorFiles(definitionDir, "queue-", ".properties");
            if (queueDescriptors != null) {
                for (int i = 0; i < queueDescriptors.length; ++i) {
                    QueueDefinition queueDef = this.loadQueueDefinition(queueDescriptors[i]);
                    if (queueDef == null) continue;
                    this.addLoadedQueueDefinition(queueDef);
                }
            }
            log.debug((Object)("Loaded " + this.queueDefinitions.size() + " queue definitions"));
            File[] topicDescriptors = DescriptorTools.getDescriptorFiles(definitionDir, "topic-", ".properties");
            if (topicDescriptors != null) {
                for (int i = 0; i < topicDescriptors.length; ++i) {
                    TopicDefinition topicDef = this.loadTopicDefinition(topicDescriptors[i]);
                    if (topicDef == null) continue;
                    this.addLoadedTopicDefinition(topicDef);
                }
            }
            log.debug((Object)("Loaded " + this.topicDefinitions.size() + " topic definitions"));
        }
    }

    private void addLoadedQueueDefinition(QueueDefinition queueDef) throws JMSException {
        queueDef.check();
        if (this.queueDefinitions.containsKey(queueDef.getName())) {
            throw new FFMQException("Queue name already used : " + queueDef.getName(), "DUPLICATE_QUEUE_DEFINITION");
        }
        this.queueDefinitions.put(queueDef.getName(), queueDef);
    }

    private void addLoadedTopicDefinition(TopicDefinition topicDef) throws JMSException {
        topicDef.check();
        if (this.topicDefinitions.containsKey(topicDef.getName())) {
            throw new FFMQException("Topic name already used : " + topicDef.getName(), "DUPLICATE_TOPIC_DEFINITION");
        }
        this.topicDefinitions.put(topicDef.getName(), topicDef);
    }

    public QueueDefinition getQueueDefinition(String queueName) throws JMSException {
        QueueDefinition queueDef = this.queueDefinitions.get(queueName);
        if (queueDef == null) {
            queueDef = this.loadQueueDefinition(queueName);
            if (queueDef == null) {
                return null;
            }
            this.queueDefinitions.put(queueName, queueDef);
        }
        return queueDef;
    }

    public boolean hasQueueDefinition(String queueName) throws JMSException {
        return this.getQueueDefinition(queueName) != null;
    }

    private QueueDefinition loadQueueDefinition(String queueName) throws JMSException {
        if (this.setup.getDestinationDefinitionsDir() == null) {
            return null;
        }
        return this.loadQueueDefinition(new File(this.setup.getDestinationDefinitionsDir(), "queue-" + queueName + ".properties"));
    }

    private QueueDefinition loadQueueDefinition(File queueDescriptor) throws JMSException {
        if (!queueDescriptor.exists()) {
            return null;
        }
        if (!queueDescriptor.canRead()) {
            throw new FFMQException("Cannot access queue definition descriptor : " + queueDescriptor.getAbsolutePath(), "FS_ERROR");
        }
        Settings queueSettings = new Settings();
        queueSettings.readFrom(queueDescriptor);
        return new QueueDefinition(queueSettings);
    }

    public void addQueueDefinition(QueueDefinition queueDef) throws JMSException {
        queueDef.check();
        if (this.queueDefinitions.containsKey(queueDef.getName())) {
            throw new FFMQException("Queue definition already exists : " + queueDef.getName(), "QUEUE_DEFINITION_ALREADY_EXIST");
        }
        if (queueDef.hasDescriptor() && this.setup.getDestinationDefinitionsDir() != null) {
            File queueDescriptor = new File(this.setup.getDestinationDefinitionsDir(), "queue-" + queueDef.getName() + ".properties");
            if (queueDescriptor.exists()) {
                throw new FFMQException("Queue descriptor already exists : " + queueDescriptor.getAbsolutePath(), "FS_ERROR");
            }
            log.debug((Object)("Persisting queue definition for " + queueDef.getName()));
            Settings queueSettings = queueDef.asSettings();
            queueSettings.writeTo(queueDescriptor, "Queue definition descriptor for " + queueDef.getName());
        }
        this.queueDefinitions.put(queueDef.getName(), queueDef);
    }

    public void removeQueueDefinition(QueueDefinition queueDef) {
        File queueDescriptor;
        if (queueDef.hasDescriptor() && this.setup.getDestinationDefinitionsDir() != null && (queueDescriptor = new File(this.setup.getDestinationDefinitionsDir(), "queue-" + queueDef.getName() + ".properties")).exists() && !queueDescriptor.delete()) {
            log.error((Object)("Cannot delete queue descriptor file : " + queueDescriptor.getAbsolutePath()));
        }
        this.queueDefinitions.remove(queueDef.getName());
    }

    public TopicDefinition getTopicDefinition(String topicName) throws JMSException {
        TopicDefinition topicDef = this.topicDefinitions.get(topicName);
        if (topicDef == null) {
            topicDef = this.loadTopicDefinition(topicName);
            if (topicDef == null) {
                return null;
            }
            this.topicDefinitions.put(topicName, topicDef);
        }
        return topicDef;
    }

    public boolean hasTopicDefinition(String queueName) throws JMSException {
        return this.getTopicDefinition(queueName) != null;
    }

    private TopicDefinition loadTopicDefinition(String topicName) throws JMSException {
        if (this.setup.getDestinationDefinitionsDir() == null) {
            return null;
        }
        return this.loadTopicDefinition(new File(this.setup.getDestinationDefinitionsDir(), "topic-" + topicName + ".properties"));
    }

    private TopicDefinition loadTopicDefinition(File topicDescriptor) throws JMSException {
        if (!topicDescriptor.exists()) {
            return null;
        }
        if (!topicDescriptor.canRead()) {
            throw new FFMQException("Cannot access topic definition descriptor : " + topicDescriptor.getAbsolutePath(), "FS_ERROR");
        }
        Settings topicSettings = new Settings();
        topicSettings.readFrom(topicDescriptor);
        return new TopicDefinition(topicSettings);
    }

    public void addTopicDefinition(TopicDefinition topicDef) throws JMSException {
        topicDef.check();
        if (this.topicDefinitions.containsKey(topicDef.getName())) {
            throw new FFMQException("Topic definition already exists : " + topicDef.getName(), "TOPIC_DEFINITION_ALREADY_EXIST");
        }
        if (this.setup.getDestinationDefinitionsDir() != null) {
            File topicDescriptor = new File(this.setup.getDestinationDefinitionsDir(), "topic-" + topicDef.getName() + ".properties");
            if (topicDescriptor.exists()) {
                throw new FFMQException("Topic descriptor already exists : " + topicDescriptor.getAbsolutePath(), "FS_ERROR");
            }
            Settings topicSettings = topicDef.asSettings();
            topicSettings.writeTo(topicDescriptor, "Topic definition descriptor for " + topicDef.getName());
        }
        this.topicDefinitions.put(topicDef.getName(), topicDef);
    }

    public void removeTopicDefinition(String topicName) {
        File topicDescriptor;
        if (this.setup.getDestinationDefinitionsDir() != null && (topicDescriptor = new File(this.setup.getDestinationDefinitionsDir(), "topic-" + topicName + ".properties")).exists() && !topicDescriptor.delete()) {
            log.error((Object)("Cannot delete topic descriptor file : " + topicDescriptor.getAbsolutePath()));
        }
        this.topicDefinitions.remove(topicName);
    }

    public String[] getAllQueueNames() {
        return this.queueDefinitions.keySet().toArray(new String[this.queueDefinitions.size()]);
    }

    public String[] getAllTopicNames() {
        return this.topicDefinitions.keySet().toArray(new String[this.topicDefinitions.size()]);
    }
}

