/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import java.util.NoSuchElementException;
import javax.jms.JMSException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageSelector;
import net.timewalker.ffmq4.common.message.MessageTools;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowserEnumeration;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.session.LocalQueueBrowser;
import net.timewalker.ffmq4.local.session.LocalQueueBrowserCursor;

public final class LocalQueueBrowserEnumeration
extends AbstractQueueBrowserEnumeration {
    private LocalQueue localQueue;
    private MessageSelector parsedSelector;
    private LocalQueueBrowserCursor cursor = new LocalQueueBrowserCursor();
    private AbstractMessage nextMessage;

    protected LocalQueueBrowserEnumeration(LocalQueueBrowser browser, LocalQueue localQueue, MessageSelector parsedSelector, String enumId) {
        super(browser, enumId);
        this.localQueue = localQueue;
        this.parsedSelector = parsedSelector;
    }

    private AbstractMessage fetchNext() throws JMSException {
        if (this.nextMessage != null) {
            return this.nextMessage;
        }
        this.nextMessage = this.localQueue.browse(this.cursor, this.parsedSelector);
        if (this.nextMessage == null) {
            this.close();
        }
        return this.nextMessage;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.cursor.endOfQueueReached()) {
            return false;
        }
        try {
            this.checkNotClosed();
            AbstractMessage msg = this.fetchNext();
            return msg != null;
        }
        catch (JMSException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public AbstractMessage nextElement() {
        if (this.cursor.endOfQueueReached()) {
            throw new NoSuchElementException();
        }
        try {
            this.checkNotClosed();
            AbstractMessage msg = this.fetchNext();
            if (msg != null) {
                this.nextMessage = null;
                AbstractMessage msgCopy = MessageTools.duplicate(msg);
                msgCopy.ensureDeserializationLevel(3);
                return msgCopy;
            }
            throw new NoSuchElementException();
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (JMSException e) {
            throw new IllegalStateException(e.toString());
        }
    }
}

