/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.destination.subscription;

import net.timewalker.ffmq4.common.message.MessageSelector;
import net.timewalker.ffmq4.common.message.selector.SelectorIndexKey;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.session.LocalMessageConsumer;

public final class LocalTopicSubscription {
    private long creationTS = System.currentTimeMillis();
    private String subscriberId;
    private MessageSelector messageSelector;
    private String connectionID;
    private boolean durable;
    private boolean noLocal;
    private SelectorIndexKey indexKey;
    private LocalQueue localQueue;

    public LocalTopicSubscription(LocalMessageConsumer consumer) {
        this.subscriberId = consumer.getSubscriberId();
        this.messageSelector = consumer.getParsedSelector();
        this.connectionID = consumer.getSession().getConnection().getId();
        this.localQueue = consumer.getLocalQueue();
        this.durable = consumer.isDurable();
        this.noLocal = consumer.getNoLocal();
    }

    public long getCreationTS() {
        return this.creationTS;
    }

    public MessageSelector getMessageSelector() {
        return this.messageSelector;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public LocalQueue getLocalQueue() {
        return this.localQueue;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public void setIndexKey(SelectorIndexKey indexKey) {
        this.indexKey = indexKey;
    }

    public SelectorIndexKey getIndexKey() {
        return this.indexKey;
    }

    public boolean isIndexed() {
        return this.indexKey != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalTopicSubscription[subscriberID=");
        sb.append(this.subscriberId);
        sb.append(",connectionID=");
        sb.append(this.connectionID);
        sb.append(",selector=");
        sb.append(this.messageSelector);
        if (this.indexKey != null) {
            sb.append(",indexKey=");
            sb.append(this.indexKey);
        }
        sb.append(",durable=");
        sb.append(this.durable);
        sb.append(",noLocal=");
        sb.append(this.noLocal);
        sb.append(",creationTS=");
        sb.append(this.creationTS);
        sb.append("] using ");
        sb.append(this.localQueue);
        return sb.toString();
    }
}

