/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local;

import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.local.TransactionItem;
import net.timewalker.ffmq4.local.destination.LocalQueue;

public final class MessageLock {
    private int handle;
    private int deliveryMode;
    private LocalQueue destination;
    private AbstractMessage message;

    public MessageLock(int handle, int deliveryMode, LocalQueue destination, AbstractMessage message) {
        this.handle = handle;
        this.deliveryMode = deliveryMode;
        this.destination = destination;
        this.message = message;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public LocalQueue getDestination() {
        return this.destination;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MessageLock] handle=");
        sb.append(this.handle);
        sb.append(" destination=");
        sb.append(this.destination);
        sb.append(" deliveryMode=");
        sb.append(this.deliveryMode);
        sb.append(" msgId=");
        sb.append(this.message.getJMSMessageID());
        return sb.toString();
    }

    public TransactionItem toTransactionItem() {
        return new TransactionItem(this.handle, this.message.getJMSMessageID(), this.deliveryMode, this.destination);
    }
}

