/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.FFMQSecurityException;
import net.timewalker.ffmq4.local.FFMQEngineListener;
import net.timewalker.ffmq4.local.FFMQEngineMBean;
import net.timewalker.ffmq4.local.connection.ClientIDRegistry;
import net.timewalker.ffmq4.local.connection.LocalConnection;
import net.timewalker.ffmq4.local.connection.LocalQueueConnection;
import net.timewalker.ffmq4.local.connection.LocalTopicConnection;
import net.timewalker.ffmq4.local.destination.AbstractLocalDestination;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.LocalTopic;
import net.timewalker.ffmq4.local.destination.subscription.DurableSubscriptionManager;
import net.timewalker.ffmq4.management.DestinationDefinitionProvider;
import net.timewalker.ffmq4.management.DestinationTemplateProvider;
import net.timewalker.ffmq4.management.FFMQEngineSetup;
import net.timewalker.ffmq4.management.TemplateMappingProvider;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.management.destination.template.QueueTemplate;
import net.timewalker.ffmq4.management.destination.template.TopicTemplate;
import net.timewalker.ffmq4.security.SecurityConnectorProvider;
import net.timewalker.ffmq4.security.SecurityContext;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.impl.BlockBasedDataStoreTools;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.async.AsyncTaskManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FFMQEngine
implements FFMQEngineMBean {
    private static final Log log = LogFactory.getLog(FFMQEngine.class);
    private static Map<String, FFMQEngine> deployedEngines = new Hashtable<String, FFMQEngine>();
    private String name;
    private FFMQEngineListener listener;
    private Map<String, LocalQueue> queueMap = new Hashtable<String, LocalQueue>();
    private Map<String, LocalTopic> topicMap = new Hashtable<String, LocalTopic>();
    private boolean deployed = false;
    private boolean securityEnabled;
    private FFMQEngineSetup setup;
    private DestinationDefinitionProvider destinationDefinitionProvider;
    private DestinationTemplateProvider destinationTemplateProvider;
    private TemplateMappingProvider templateMappingProvider;
    private DurableSubscriptionManager durableSubscriptionManager;
    private AsyncTaskManager notificationAsyncTaskManager;
    private AsyncTaskManager deliveryAsyncTaskManager;
    private AsyncTaskManager diskIOAsyncTaskManager;

    public static FFMQEngine getDeployedInstance(String name) throws JMSException {
        FFMQEngine engine = deployedEngines.get(name);
        if (engine == null) {
            throw new FFMQException("No deployed engine named " + name, "UNKNOWN_ENGINE");
        }
        return engine;
    }

    public FFMQEngine(String name, Settings engineSettings) throws FFMQException {
        this(name, engineSettings, null);
    }

    public FFMQEngine(String name, Settings engineSettings, FFMQEngineListener listener) throws FFMQException {
        this.name = name;
        this.listener = listener;
        this.setup = new FFMQEngineSetup(engineSettings);
        this.init();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void checkDeployed() throws JMSException {
        if (!this.deployed) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void init() {
        this.destinationDefinitionProvider = new DestinationDefinitionProvider(this.setup);
        this.destinationTemplateProvider = new DestinationTemplateProvider(this.setup);
        this.templateMappingProvider = new TemplateMappingProvider(this.setup);
        this.securityEnabled = this.setup.isSecurityEnabled();
        this.durableSubscriptionManager = new DurableSubscriptionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws JMSException {
        try {
            Map<String, FFMQEngine> map = deployedEngines;
            synchronized (map) {
                if (this.deployed) {
                    throw new FFMQException("Local engine is already deployed.", "ENGINE_ALREADY_DEPLOYED");
                }
                log.info((Object)("Deploying local engine '" + this.name + "'"));
                this.destinationDefinitionProvider.loadExistingDefinitions();
                this.destinationTemplateProvider.loadExistingTemplates();
                this.templateMappingProvider.loadMappings();
                this.notificationAsyncTaskManager = new AsyncTaskManager("AsyncTaskManager-notification-" + this.name, this.setup.getNotificationAsyncTaskManagerThreadPoolMinSize(), this.setup.getNotificationAsyncTaskManagerThreadPoolMaxIdle(), this.setup.getNotificationAsyncTaskManagerThreadPoolMaxSize());
                this.deliveryAsyncTaskManager = new AsyncTaskManager("AsyncTaskManager-delivery-" + this.name, this.setup.getDeliveryAsyncTaskManagerThreadPoolMinSize(), this.setup.getDeliveryAsyncTaskManagerThreadPoolMaxIdle(), this.setup.getDeliveryAsyncTaskManagerThreadPoolMaxSize());
                this.diskIOAsyncTaskManager = new AsyncTaskManager("AsyncTaskManager-diskIO-" + this.name, this.setup.getDiskIOAsyncTaskManagerThreadPoolMinSize(), this.setup.getDiskIOAsyncTaskManagerThreadPoolMaxIdle(), this.setup.getDiskIOAsyncTaskManagerThreadPoolMaxSize());
                this.deleteTemporaryDestinations();
                if (this.setup.doDeployQueuesOnStartup()) {
                    this.deployExistingQueues();
                }
                if (this.setup.doDeployTopicsOnStartup()) {
                    this.deployExistingTopics();
                }
                deployedEngines.put(this.name, this);
                this.deployed = true;
                log.info((Object)("Engine deployed (vm://" + this.name + ")"));
            }
            if (this.listener != null) {
                this.listener.engineDeployed();
            }
        }
        catch (JMSException e) {
            log.error((Object)("Cannot deploy engine : " + e.getMessage()));
            throw e;
        }
    }

    public DestinationTemplateProvider getDestinationTemplateProvider() {
        return this.destinationTemplateProvider;
    }

    public TemplateMappingProvider getTemplateMappingProvider() {
        return this.templateMappingProvider;
    }

    private void deleteTemporaryDestinations() throws JMSException {
        String[] queueNames = this.destinationDefinitionProvider.getAllQueueNames();
        for (int i = 0; i < queueNames.length; ++i) {
            QueueDefinition queueDef = this.destinationDefinitionProvider.getQueueDefinition(queueNames[i]);
            if (!queueDef.isTemporary()) continue;
            log.info((Object)("Deleting old temporary queue : " + queueNames[i]));
            this.deleteQueue(queueNames[i], true);
        }
        String[] topicNames = this.destinationDefinitionProvider.getAllTopicNames();
        for (int i = 0; i < topicNames.length; ++i) {
            TopicDefinition topicDef = this.destinationDefinitionProvider.getTopicDefinition(topicNames[i]);
            if (!topicDef.isTemporary()) continue;
            log.info((Object)("Deleting old temporary topic : " + topicNames[i]));
            this.deleteTopic(topicNames[i]);
        }
    }

    private void deployExistingQueues() {
        log.info((Object)"Deploying existing queues");
        String[] queueNames = this.destinationDefinitionProvider.getAllQueueNames();
        for (int i = 0; i < queueNames.length; ++i) {
            try {
                this.getLocalQueue(queueNames[i]);
                continue;
            }
            catch (JMSException e) {
                ErrorTools.log(e, log);
            }
        }
    }

    private void deployExistingTopics() {
        log.info((Object)"Deploying existing topics");
        String[] topicNames = this.destinationDefinitionProvider.getAllTopicNames();
        for (int i = 0; i < topicNames.length; ++i) {
            try {
                this.getLocalTopic(topicNames[i]);
                continue;
            }
            catch (JMSException e) {
                ErrorTools.log(e, log);
            }
        }
    }

    public FFMQEngineSetup getSetup() {
        return this.setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        Map<String, FFMQEngine> map = deployedEngines;
        synchronized (map) {
            int i;
            if (!this.deployed) {
                return;
            }
            log.info((Object)("Undeploying local engine '" + this.name + "'"));
            this.durableSubscriptionManager = null;
            if (this.notificationAsyncTaskManager != null) {
                this.notificationAsyncTaskManager.close();
                this.notificationAsyncTaskManager = null;
            }
            if (this.deliveryAsyncTaskManager != null) {
                this.deliveryAsyncTaskManager.close();
                this.deliveryAsyncTaskManager = null;
            }
            Map<String, AbstractLocalDestination> map2 = this.queueMap;
            synchronized (map2) {
                ArrayList<LocalQueue> queues = new ArrayList<LocalQueue>();
                queues.addAll(this.queueMap.values());
                for (i = 0; i < queues.size(); ++i) {
                    LocalQueue localQueue = (LocalQueue)queues.get(i);
                    try {
                        this.undeployQueue(localQueue);
                        continue;
                    }
                    catch (JMSException e) {
                        ErrorTools.log(e, log);
                    }
                }
            }
            map2 = this.topicMap;
            synchronized (map2) {
                ArrayList<LocalTopic> topics = new ArrayList<LocalTopic>();
                topics.addAll(this.topicMap.values());
                for (i = 0; i < topics.size(); ++i) {
                    LocalTopic localTopic = (LocalTopic)topics.get(i);
                    try {
                        this.undeployTopic(localTopic);
                        continue;
                    }
                    catch (JMSException e) {
                        ErrorTools.log(e, log);
                    }
                }
            }
            if (this.diskIOAsyncTaskManager != null) {
                this.diskIOAsyncTaskManager.close();
                this.diskIOAsyncTaskManager = null;
            }
            this.destinationTemplateProvider.clear();
            deployedEngines.remove(this.name);
            this.deployed = false;
        }
        if (this.listener != null) {
            this.listener.engineUndeployed();
        }
    }

    public Connection openConnection(String userName, String password, String clientID) throws JMSException {
        this.checkDeployed();
        if (clientID != null) {
            ClientIDRegistry.getInstance().register(clientID);
        }
        return new LocalConnection(this, this.getSecurityContext(userName, password), clientID);
    }

    public QueueConnection openQueueConnection(String userName, String password, String clientID) throws JMSException {
        this.checkDeployed();
        if (clientID != null) {
            ClientIDRegistry.getInstance().register(clientID);
        }
        return new LocalQueueConnection(this, this.getSecurityContext(userName, password), clientID);
    }

    public TopicConnection openTopicConnection(String userName, String password, String clientID) throws JMSException {
        this.checkDeployed();
        if (clientID != null) {
            ClientIDRegistry.getInstance().register(clientID);
        }
        return new LocalTopicConnection(this, this.getSecurityContext(userName, password), clientID);
    }

    private SecurityContext getSecurityContext(String userName, String password) throws JMSException {
        if (!this.securityEnabled) {
            return null;
        }
        if (userName == null || password == null) {
            throw new FFMQSecurityException("Missing security credentials", "MISSING_CREDENTIALS");
        }
        return SecurityConnectorProvider.getConnector(this.setup).getContext(userName, password);
    }

    public LocalQueue createTemporaryQueue(String queueName) throws JMSException {
        String templateName = this.templateMappingProvider.getTemplateNameForQueue(queueName);
        if (StringTools.isEmpty(templateName)) {
            throw new FFMQException("No template matching queue : " + queueName, "MISSING_TEMPLATE_MAPPING");
        }
        QueueTemplate queueTemplate = this.destinationTemplateProvider.getQueueTemplate(templateName);
        if (queueTemplate == null) {
            throw new FFMQException("Queue template does not exist : " + templateName, "MISSING_TEMPLATE");
        }
        QueueDefinition tempDef = queueTemplate.createQueueDefinition(queueName, true);
        return this.createQueue(tempDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalQueue createQueue(QueueDefinition queueDef) throws JMSException {
        queueDef.check();
        if (queueDef.hasPersistentStore() && this.setup.getDestinationDefinitionsDir() == null) {
            throw new FFMQException("Cannot create a persistent queue if destinations folder is not set.", "INVALID_CONFIGURATION");
        }
        Map<String, LocalQueue> map = this.queueMap;
        synchronized (map) {
            if (this.destinationDefinitionProvider.getQueueDefinition(queueDef.getName()) != null) {
                throw new FFMQException("Queue definition already exists : " + queueDef.getName(), "QUEUE_ALREADY_EXISTS");
            }
            this.destinationDefinitionProvider.addQueueDefinition(queueDef);
            if (queueDef.hasPersistentStore()) {
                log.debug((Object)("Creating local store for queue : " + queueDef.getName()));
                try {
                    BlockBasedDataStoreTools.create(queueDef.getName(), queueDef.getDataFolder(), queueDef.getInitialBlockCount(), queueDef.getBlockSize(), !queueDef.isTemporary());
                }
                catch (DataStoreException e) {
                    this.destinationDefinitionProvider.removeQueueDefinition(queueDef);
                    throw e;
                }
            }
            return this.getLocalQueue(queueDef.getName());
        }
    }

    public LocalTopic createTemporaryTopic(String topicName) throws JMSException {
        String templateName = this.templateMappingProvider.getTemplateNameForTopic(topicName);
        if (StringTools.isEmpty(templateName)) {
            throw new FFMQException("No template matching topic : " + topicName, "MISSING_TEMPLATE_MAPPING");
        }
        TopicTemplate topicTemplate = this.destinationTemplateProvider.getTopicTemplate(templateName);
        if (topicTemplate == null) {
            throw new FFMQException("Topic template does not exist : " + templateName, "MISSING_TEMPLATE");
        }
        TopicDefinition tempDef = topicTemplate.createTopicDefinition(topicName, true);
        return this.createTopic(tempDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTopic createTopic(TopicDefinition topicDef) throws JMSException {
        topicDef.check();
        Map<String, LocalTopic> map = this.topicMap;
        synchronized (map) {
            if (this.destinationDefinitionProvider.getTopicDefinition(topicDef.getName()) != null) {
                throw new FFMQException("Topic definition already exists : " + topicDef.getName(), "TOPIC_ALREADY_EXISTS");
            }
            this.destinationDefinitionProvider.addTopicDefinition(topicDef);
            return this.getLocalTopic(topicDef.getName());
        }
    }

    public void deleteQueue(String queueName) throws JMSException {
        this.deleteQueue(queueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQueue(String queueName, boolean force) throws JMSException {
        Map<String, LocalQueue> map = this.queueMap;
        synchronized (map) {
            QueueDefinition queueDef;
            LocalQueue queue = this.queueMap.get(queueName);
            if (queue != null) {
                this.undeployQueue(queue);
                log.debug((Object)("Undeployed local queue : " + queueName));
            }
            if ((queueDef = this.destinationDefinitionProvider.getQueueDefinition(queueName)) != null) {
                this.destinationDefinitionProvider.removeQueueDefinition(queueDef);
                if (queueDef.hasPersistentStore()) {
                    BlockBasedDataStoreTools.delete(queueDef.getName(), queueDef.getDataFolder(), force);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTopic(String topicName) throws JMSException {
        Map<String, LocalTopic> map = this.topicMap;
        synchronized (map) {
            TopicDefinition topicDef;
            LocalTopic topic = this.topicMap.remove(topicName);
            if (topic != null) {
                this.undeployTopic(topic);
                log.debug((Object)("Undeployed local topic : " + topicName));
            }
            if ((topicDef = this.destinationDefinitionProvider.getTopicDefinition(topicName)) != null) {
                this.destinationDefinitionProvider.removeTopicDefinition(topicName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalQueue getLocalQueue(String queueName) throws JMSException {
        Map<String, LocalQueue> map = this.queueMap;
        synchronized (map) {
            LocalQueue queue = this.queueMap.get(queueName);
            if (queue == null) {
                return this.loadOrAutoCreateQueue(queueName);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean localQueueExists(String queueName) throws JMSException {
        Map<String, LocalQueue> map = this.queueMap;
        synchronized (map) {
            LocalQueue queue = this.queueMap.get(queueName);
            if (queue != null) {
                return true;
            }
            return this.destinationDefinitionProvider.getQueueDefinition(queueName) != null;
            {
            }
        }
    }

    private void deployQueue(LocalQueue queue) {
        this.queueMap.put(queue.getName(), queue);
        if (this.listener != null) {
            this.listener.queueDeployed(queue);
        }
    }

    private void deployTopic(LocalTopic topic) {
        this.topicMap.put(topic.getName(), topic);
        if (this.listener != null) {
            this.listener.topicDeployed(topic);
        }
    }

    private void undeployQueue(LocalQueue queue) throws JMSException {
        queue.close();
        this.queueMap.remove(queue.getName());
        if (queue.getDefinition().isTemporary()) {
            this.destinationDefinitionProvider.removeQueueDefinition(queue.getDefinition());
        }
        if (this.listener != null) {
            this.listener.queueUndeployed(queue);
        }
    }

    private void undeployTopic(LocalTopic topic) throws JMSException {
        topic.close();
        this.topicMap.remove(topic.getName());
        if (this.listener != null) {
            this.listener.topicUndeployed(topic);
        }
    }

    private LocalQueue loadOrAutoCreateQueue(String queueName) throws JMSException {
        QueueTemplate queueTemplate;
        String templateName;
        QueueDefinition queueDef = this.destinationDefinitionProvider.getQueueDefinition(queueName);
        if (queueDef != null) {
            LocalQueue queue = new LocalQueue(this, queueDef);
            this.deployQueue(queue);
            return queue;
        }
        if (this.setup.doAutoCreateQueues() && (templateName = this.templateMappingProvider.getTemplateNameForQueue(queueName)) != null && (queueTemplate = this.destinationTemplateProvider.getQueueTemplate(templateName)) != null) {
            return this.createQueue(queueTemplate.createQueueDefinition(queueName, false));
        }
        throw new FFMQException("Queue does not exist : " + queueName, "QUEUE_DOES_NOT_EXIST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTopic getLocalTopic(String topicName) throws JMSException {
        Map<String, LocalTopic> map = this.topicMap;
        synchronized (map) {
            LocalTopic topic = this.topicMap.get(topicName);
            if (topic == null) {
                return this.loadOrAutoCreateTopic(topicName);
            }
            return topic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean localTopicExists(String topicName) throws JMSException {
        Map<String, LocalTopic> map = this.topicMap;
        synchronized (map) {
            LocalTopic topic = this.topicMap.get(topicName);
            if (topic != null) {
                return true;
            }
            return this.destinationDefinitionProvider.getTopicDefinition(topicName) != null;
            {
            }
        }
    }

    private LocalTopic loadOrAutoCreateTopic(String topicName) throws JMSException {
        TopicTemplate topicTemplate;
        String templateName;
        TopicDefinition topicDef = this.destinationDefinitionProvider.getTopicDefinition(topicName);
        if (topicDef != null) {
            LocalTopic topic = new LocalTopic(topicDef);
            this.deployTopic(topic);
            return topic;
        }
        if (this.setup.doAutoCreateTopics() && (templateName = this.templateMappingProvider.getTemplateNameForTopic(topicName)) != null && (topicTemplate = this.destinationTemplateProvider.getTopicTemplate(templateName)) != null) {
            return this.createTopic(topicTemplate.createTopicDefinition(topicName, false));
        }
        throw new FFMQException("Topic does not exist : " + topicName, "TOPIC_DOES_NOT_EXIST");
    }

    public void subscribe(String clientID, String subscriptionName) throws JMSException {
        if (this.durableSubscriptionManager == null) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
        if (this.durableSubscriptionManager.register(clientID, subscriptionName)) {
            log.debug((Object)("Storing a new durable subscription : " + clientID + "-" + subscriptionName));
        } else {
            log.debug((Object)("Subscription already exist : " + clientID + "-" + subscriptionName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String clientID, String subscriptionName) throws JMSException {
        if (this.durableSubscriptionManager == null) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
        if (!this.durableSubscriptionManager.isRegistered(clientID, subscriptionName)) {
            throw new InvalidDestinationException("Invalid subscription : " + subscriptionName + " for client " + clientID);
        }
        Map<String, LocalTopic> map = this.topicMap;
        synchronized (map) {
            for (LocalTopic topic : this.topicMap.values()) {
                topic.unsubscribe(clientID, subscriptionName);
            }
        }
        String subscriberID = clientID + "-" + subscriptionName;
        Map<String, LocalQueue> map2 = this.queueMap;
        synchronized (map2) {
            ArrayList<String> queuesToDelete = new ArrayList<String>();
            for (String queueName : this.queueMap.keySet()) {
                if (!queueName.endsWith(subscriberID)) continue;
                queuesToDelete.add(queueName);
            }
            for (int i = 0; i < queuesToDelete.size(); ++i) {
                this.deleteQueue((String)queuesToDelete.get(i));
            }
        }
        if (!this.durableSubscriptionManager.unregister(clientID, subscriptionName)) {
            log.error((Object)("Unknown durable subscription : " + clientID + "-" + subscriptionName));
        }
    }

    public AsyncTaskManager getNotificationAsyncTaskManager() throws JMSException {
        if (this.notificationAsyncTaskManager == null) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
        return this.notificationAsyncTaskManager;
    }

    public AsyncTaskManager getDeliveryAsyncTaskManager() throws JMSException {
        if (this.deliveryAsyncTaskManager == null) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
        return this.deliveryAsyncTaskManager;
    }

    public AsyncTaskManager getDiskIOAsyncTaskManager() throws JMSException {
        if (this.diskIOAsyncTaskManager == null) {
            throw new FFMQException("Engine is stopped.", "ENGINE_STOPPED");
        }
        return this.diskIOAsyncTaskManager;
    }

    public DestinationDefinitionProvider getDestinationDefinitionProvider() {
        return this.destinationDefinitionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllStatistics() {
        Map<String, AbstractLocalDestination> map = this.queueMap;
        synchronized (map) {
            for (LocalQueue queue : this.queueMap.values()) {
                queue.resetStats();
            }
        }
        map = this.topicMap;
        synchronized (map) {
            for (LocalTopic topic : this.topicMap.values()) {
                topic.resetStats();
            }
        }
    }
}

