/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jndi;

import java.net.URI;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jndi.FFMQConnectionFactory;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.remote.connection.RemoteTopicConnection;

public final class FFMQTopicConnectionFactory
extends FFMQConnectionFactory
implements TopicConnectionFactory {
    private static final long serialVersionUID = 1L;

    public FFMQTopicConnectionFactory() {
    }

    public FFMQTopicConnectionFactory(Hashtable<String, Object> environment) {
        super(environment);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        String username = this.getStringProperty("java.naming.security.principal", null);
        String password = this.getStringProperty("java.naming.security.credentials", null);
        return this.createTopicConnection(username, password);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        URI providerURL = this.getProviderURI();
        String scheme = providerURL.getScheme();
        if (scheme.equals("vm")) {
            String engineName = providerURL.getHost();
            return FFMQEngine.getDeployedInstance(engineName).openTopicConnection(userName, password, this.clientID);
        }
        if (scheme.equals("tcp") || scheme.equals("tcps") || scheme.equals("tcpnio")) {
            return new RemoteTopicConnection(providerURL, userName, password, this.clientID);
        }
        throw new FFMQException("Unknown transport protocol : " + scheme, "INVALID_TRANSPORT_PROTOCOL");
    }
}

