/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.JavaTools;
import net.timewalker.ffmq4.utils.id.IntegerID;

public abstract class AbstractMessageHandler {
    protected IntegerID id;
    protected AbstractConnection connection;
    protected AbstractSession session;
    protected Destination destination;
    protected boolean closed;
    protected ReadWriteLock externalAccessLock = new ReentrantReadWriteLock();

    public AbstractMessageHandler(AbstractSession session, Destination destination, IntegerID handlerId) {
        this.session = session;
        this.connection = session.getConnection();
        this.destination = destination;
        this.id = handlerId;
    }

    public final IntegerID getId() {
        return this.id;
    }

    public final AbstractSession getSession() {
        return this.session;
    }

    protected final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Message handler is closed");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaTools.getShortClassName(this.getClass()));
        sb.append("[#");
        sb.append(this.id);
        sb.append("]");
        if (this.destination != null) {
            sb.append("(destination=");
            sb.append(this.destination);
            sb.append(")");
        }
        return sb.toString();
    }

    public final void getEntitiesDescription(StringBuilder sb) {
        sb.append(this.toString());
    }
}

