/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.session.AbstractMessageHandler;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageConsumer
extends AbstractMessageHandler
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(AbstractMessageConsumer.class);
    protected String messageSelector;
    protected boolean noLocal;
    protected MessageListener messageListener;
    protected boolean autoAcknowledge;

    public AbstractMessageConsumer(AbstractSession session, Destination destination, String messageSelector, boolean noLocal, IntegerID consumerId) throws JMSException {
        super(session, destination, consumerId);
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        boolean bl = this.autoAcknowledge = session.getAcknowledgeMode() == 1 || session.getAcknowledgeMode() == 3;
        if (destination == null) {
            throw new FFMQException("Message consumer destination cannot be null", "INVALID_DESTINATION");
        }
    }

    protected abstract boolean shouldLogListenersFailures();

    public final void close() throws JMSException {
        this.externalAccessLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onConsumerClose();
        }
        finally {
            this.externalAccessLock.writeLock().unlock();
        }
        this.onConsumerClosed();
    }

    protected void onConsumerClose() {
        this.session.unregisterConsumer(this);
    }

    protected void onConsumerClosed() {
    }

    public final String getMessageSelector() {
        return this.messageSelector;
    }

    public final MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.messageListener = messageListener;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final Message receive() throws JMSException {
        return this.receive(-1L);
    }

    public final Message receiveNoWait() throws JMSException {
        return this.receive(0L);
    }

    public final Message receive(long timeout) throws JMSException {
        if (this.messageListener != null) {
            throw new FFMQException("Cannot receive messages while a listener is active", "INVALID_OPERATION");
        }
        AbstractMessage message = this.receiveFromDestination(timeout, true);
        if (message != null) {
            message.ensureDeserializationLevel(3);
            message.setSession(this.session);
            if (this.autoAcknowledge) {
                this.session.acknowledge();
            }
        }
        return message;
    }

    protected abstract AbstractMessage receiveFromDestination(long var1, boolean var3) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void wakeUpMessageListener() {
        try {
            while (!this.closed) {
                Object object = this.session.deliveryLock;
                synchronized (object) {
                    boolean listenerFailed;
                    block11: {
                        AbstractMessage message = this.receiveFromDestination(0L, true);
                        if (message == null) {
                            return;
                        }
                        message.ensureDeserializationLevel(3);
                        message.setSession(this.session);
                        listenerFailed = false;
                        try {
                            this.messageListener.onMessage((Message)message);
                        }
                        catch (Throwable e) {
                            listenerFailed = true;
                            if (!this.shouldLogListenersFailures()) break block11;
                            log.error((Object)"Message listener failed", e);
                        }
                    }
                    if (this.autoAcknowledge) {
                        if (listenerFailed) {
                            this.session.recover();
                        } else {
                            this.session.acknowledge();
                        }
                    }
                }
            }
            return;
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
            this.connection.exceptionOccured(e);
        }
    }

    protected abstract void wakeUp() throws JMSException;
}

