/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.ConditionalExpression;
import net.timewalker.ffmq4.common.message.selector.expression.Identifier;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractBinaryOperator;
import net.timewalker.ffmq4.common.message.selector.expression.utils.StringUtils;

public class LikeOperator
extends AbstractBinaryOperator
implements ConditionalExpression {
    protected SelectorNode escapeOperand;

    public LikeOperator(SelectorNode leftOperand, SelectorNode rightOperand, SelectorNode escapeOperand) throws InvalidSelectorException {
        super(leftOperand, rightOperand);
        this.escapeOperand = escapeOperand;
        if (!(leftOperand instanceof Identifier)) {
            throw new InvalidSelectorException("left operand of LIKE operator must be an identifier");
        }
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        String leftValue = this.leftOperand.evaluateString(message);
        String rightValue = this.rightOperand.evaluateString(message);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        String escapeValue = this.escapeOperand != null ? this.escapeOperand.evaluateString(message) : null;
        return StringUtils.matches(leftValue, rightValue, escapeValue);
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " LIKE " + this.parenthesize(this.rightOperand) + (this.escapeOperand != null ? " ESCAPE " + this.parenthesize(this.escapeOperand) : "");
    }
}

