/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.ConditionalExpression;
import net.timewalker.ffmq4.common.message.selector.expression.Identifier;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractBinaryOperator;

public class InOperator
extends AbstractBinaryOperator
implements ConditionalExpression {
    public InOperator(SelectorNode leftOperand, SelectorNode rightOperand) throws InvalidSelectorException {
        super(leftOperand, rightOperand);
        if (!(leftOperand instanceof Identifier)) {
            throw new InvalidSelectorException("left operand of IN operator must be an identifier");
        }
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        String leftValue = this.leftOperand.evaluateString(message);
        String[] rightValue = (String[])this.rightOperand.evaluate(message);
        if (leftValue == null) {
            return null;
        }
        for (int n = 0; n < rightValue.length; ++n) {
            if (rightValue[n] == null || !leftValue.equals(rightValue[n])) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " IN " + this.parenthesize(this.rightOperand);
    }
}

