/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractComparisonOperator;
import net.timewalker.ffmq4.common.message.selector.expression.utils.ArithmeticUtils;

public class EqualsOperator
extends AbstractComparisonOperator {
    public EqualsOperator(SelectorNode leftOperand, SelectorNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        int rightType;
        Object leftValue = this.leftOperand.evaluate(message);
        Object rightValue = this.rightOperand.evaluate(message);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        int leftType = this.getNodeType(leftValue);
        if (leftType != (rightType = this.getNodeType(rightValue))) {
            return Boolean.FALSE;
        }
        switch (leftType) {
            case 1: 
            case 3: {
                return leftValue.equals(rightValue) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return ArithmeticUtils.equals((Number)leftValue, (Number)rightValue);
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " = " + this.parenthesize(this.rightOperand);
    }
}

