/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector;

import java.util.ArrayList;
import javax.jms.InvalidSelectorException;
import net.timewalker.ffmq4.common.message.selector.MessageSelectorTokenizer;
import net.timewalker.ffmq4.common.message.selector.expression.ConditionalExpression;
import net.timewalker.ffmq4.common.message.selector.expression.Identifier;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.literal.BooleanLiteral;
import net.timewalker.ffmq4.common.message.selector.expression.literal.NullLiteral;
import net.timewalker.ffmq4.common.message.selector.expression.literal.NumericLiteral;
import net.timewalker.ffmq4.common.message.selector.expression.literal.StringLiteral;
import net.timewalker.ffmq4.common.message.selector.expression.literal.StringLiteralList;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AndOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.BetweenOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.DivideOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.EqualsOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.GreaterThanOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.GreaterThanOrEqualsOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.InOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.IsNotNullOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.IsNullOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.LessThanOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.LessThanOrEqualsOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.LikeOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.MinusOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.MultiplyOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.NotBetweenOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.NotEqualsOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.NotInOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.NotLikeOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.NotOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.OrOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.SubstractOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.SumOperator;
import net.timewalker.ffmq4.common.message.selector.expression.utils.StringUtils;

public final class MessageSelectorParser {
    private static final String[] COMPARISON_OPERATORS = new String[]{"=", "<>", "<", ">", "<=", ">="};
    private static final String[] SPECIAL_OPERATORS = new String[]{"in", "not in", "like", "not like", "between", "not between", "is null", "is not null", "is true", "is false", "is not true", "is not false"};
    private MessageSelectorTokenizer tokenizer;
    private String currentToken;

    public MessageSelectorParser(String messageSelector) throws InvalidSelectorException {
        this.tokenizer = new MessageSelectorTokenizer(messageSelector);
        this.readNextToken();
    }

    private void readNextToken() {
        this.currentToken = this.tokenizer.nextToken();
    }

    private boolean isEndOfExpression() {
        return this.currentToken == null;
    }

    public SelectorNode parse() throws InvalidSelectorException {
        if (this.isEndOfExpression()) {
            return null;
        }
        SelectorNode expr = this.parseExpression();
        if (!this.isEndOfExpression()) {
            throw new InvalidSelectorException("Unexpected token : " + this.currentToken);
        }
        if (!(expr instanceof ConditionalExpression)) {
            throw new InvalidSelectorException("Selector expression is not a boolean expression");
        }
        return expr;
    }

    private boolean isLiteral(String token) {
        if (token.charAt(0) == '\'') {
            return true;
        }
        return Character.isDigit(token.charAt(0));
    }

    private boolean isComparisonOperator(String token) {
        for (int n = 0; n < COMPARISON_OPERATORS.length; ++n) {
            if (!COMPARISON_OPERATORS[n].equals(token)) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialOperator(String token) {
        for (int n = 0; n < SPECIAL_OPERATORS.length; ++n) {
            if (!SPECIAL_OPERATORS[n].equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    private boolean isIdentifier(String token) {
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        for (int n = 1; n < token.length(); ++n) {
            if (Character.isJavaIdentifierPart(token.charAt(n))) continue;
            return false;
        }
        return !token.equalsIgnoreCase("NULL") && !token.equalsIgnoreCase("TRUE") && !token.equalsIgnoreCase("FALSE") && !token.equalsIgnoreCase("NOT") && !token.equalsIgnoreCase("AND") && !token.equalsIgnoreCase("OR") && !token.equalsIgnoreCase("BETWEEN") && !token.equalsIgnoreCase("LIKE") && !token.equalsIgnoreCase("IN") && !token.equalsIgnoreCase("IS") && !token.equalsIgnoreCase("ESCAPE");
    }

    private SelectorNode parseExpression() throws InvalidSelectorException {
        return this.parseOrExpression();
    }

    private SelectorNode parseSpecialConstructs() throws InvalidSelectorException {
        SelectorNode lNode = this.parseComparison();
        if (this.isSpecialOperator(this.currentToken)) {
            if (this.currentToken.equalsIgnoreCase("is null")) {
                this.readNextToken();
                return new IsNullOperator(lNode);
            }
            if (this.currentToken.equalsIgnoreCase("is not null")) {
                this.readNextToken();
                return new IsNotNullOperator(lNode);
            }
            if (this.currentToken.equalsIgnoreCase("is true")) {
                this.readNextToken();
                return new EqualsOperator(lNode, new BooleanLiteral(Boolean.TRUE));
            }
            if (this.currentToken.equalsIgnoreCase("is false")) {
                this.readNextToken();
                return new EqualsOperator(lNode, new BooleanLiteral(Boolean.FALSE));
            }
            if (this.currentToken.equalsIgnoreCase("is not true")) {
                this.readNextToken();
                return new EqualsOperator(lNode, new BooleanLiteral(Boolean.FALSE));
            }
            if (this.currentToken.equalsIgnoreCase("is not false")) {
                this.readNextToken();
                return new EqualsOperator(lNode, new BooleanLiteral(Boolean.TRUE));
            }
            if (this.currentToken.equalsIgnoreCase("in")) {
                this.readNextToken();
                return new InOperator(lNode, this.parseListConstruct());
            }
            if (this.currentToken.equalsIgnoreCase("not in")) {
                this.readNextToken();
                return new NotInOperator(lNode, this.parseListConstruct());
            }
            if (this.currentToken.equalsIgnoreCase("like")) {
                this.readNextToken();
                return new LikeOperator(lNode, this.parsePatternExpression(), this.parseEscapeExpression());
            }
            if (this.currentToken.equalsIgnoreCase("not like")) {
                this.readNextToken();
                return new NotLikeOperator(lNode, this.parsePatternExpression(), this.parseEscapeExpression());
            }
            if (this.currentToken.equalsIgnoreCase("between")) {
                this.readNextToken();
                SelectorNode lowerBound = this.parseAdditiveExpression();
                if (this.isEndOfExpression()) {
                    throw new InvalidSelectorException("Unexpected end of expression");
                }
                if (!this.currentToken.equalsIgnoreCase("and")) {
                    throw new InvalidSelectorException("Expected an AND operator after lower bound in BETWEEN construct");
                }
                this.readNextToken();
                SelectorNode upperBound = this.parseAdditiveExpression();
                return new BetweenOperator(lNode, lowerBound, upperBound);
            }
            if (this.currentToken.equalsIgnoreCase("not between")) {
                this.readNextToken();
                SelectorNode lowerBound = this.parseAdditiveExpression();
                if (this.isEndOfExpression()) {
                    throw new InvalidSelectorException("Unexpected end of expression");
                }
                if (!this.currentToken.equalsIgnoreCase("and")) {
                    throw new InvalidSelectorException("Expected an AND operator after lower bound in BETWEEN construct");
                }
                this.readNextToken();
                SelectorNode upperBound = this.parseAdditiveExpression();
                return new NotBetweenOperator(lNode, lowerBound, upperBound);
            }
        }
        return lNode;
    }

    private SelectorNode parseListConstruct() throws InvalidSelectorException {
        if (this.isEndOfExpression()) {
            throw new InvalidSelectorException("Unexpected end of expression");
        }
        if (!this.currentToken.equals("(")) {
            throw new InvalidSelectorException("Expected an open parenthesis after IN operator");
        }
        this.readNextToken();
        ArrayList<SelectorNode> items = new ArrayList<SelectorNode>();
        while (!this.isEndOfExpression() && !this.currentToken.equals(")")) {
            SelectorNode item = this.parseBaseExpression();
            items.add(item);
            if (this.isEndOfExpression()) {
                throw new InvalidSelectorException("Unexpected end of expression");
            }
            if (this.currentToken.equals(",")) {
                this.readNextToken();
                continue;
            }
            if (this.currentToken.equals(")")) {
                this.readNextToken();
                break;
            }
            throw new InvalidSelectorException("Unexpected token in list : " + this.currentToken);
        }
        SelectorNode[] itemList = items.toArray(new SelectorNode[items.size()]);
        return new StringLiteralList(itemList);
    }

    private SelectorNode parsePatternExpression() throws InvalidSelectorException {
        if (this.isEndOfExpression()) {
            throw new InvalidSelectorException("Expected pattern operand after LIKE operator");
        }
        SelectorNode patternNode = this.parseBaseExpression();
        if (!(patternNode instanceof StringLiteral)) {
            throw new InvalidSelectorException("pattern operand of LIKE operator should be a string literal");
        }
        return patternNode;
    }

    private SelectorNode parseEscapeExpression() throws InvalidSelectorException {
        if (!this.isEndOfExpression() && this.currentToken.equalsIgnoreCase("escape")) {
            this.readNextToken();
            SelectorNode escapeNode = this.parseBaseExpression();
            if (!(escapeNode instanceof StringLiteral)) {
                throw new InvalidSelectorException("escape operand of LIKE operator should be a string literal");
            }
            String value = (String)((StringLiteral)escapeNode).getValue();
            if (value.length() != 1) {
                throw new InvalidSelectorException("escape operand of LIKE operator must contain one and only one character");
            }
            return escapeNode;
        }
        return null;
    }

    private SelectorNode parseAndExpression() throws InvalidSelectorException {
        SelectorNode lNode = this.parseSpecialConstructs();
        while (!this.isEndOfExpression() && this.currentToken.equalsIgnoreCase("and")) {
            this.readNextToken();
            lNode = new AndOperator(lNode, this.parseSpecialConstructs());
        }
        return lNode;
    }

    private SelectorNode parseOrExpression() throws InvalidSelectorException {
        SelectorNode lNode = this.parseAndExpression();
        while (!this.isEndOfExpression() && this.currentToken.equalsIgnoreCase("or")) {
            this.readNextToken();
            lNode = new OrOperator(lNode, this.parseAndExpression());
        }
        return lNode;
    }

    private SelectorNode parseComparison() throws InvalidSelectorException {
        SelectorNode lNode = this.parseAdditiveExpression();
        if (!this.isEndOfExpression() && this.isComparisonOperator(this.currentToken)) {
            if (this.currentToken.equals("=")) {
                this.readNextToken();
                return new EqualsOperator(lNode, this.parseAdditiveExpression());
            }
            if (this.currentToken.equals("<>")) {
                this.readNextToken();
                return new NotEqualsOperator(lNode, this.parseAdditiveExpression());
            }
            if (this.currentToken.equals("<")) {
                this.readNextToken();
                return new LessThanOperator(lNode, this.parseAdditiveExpression());
            }
            if (this.currentToken.equals(">")) {
                this.readNextToken();
                return new GreaterThanOperator(lNode, this.parseAdditiveExpression());
            }
            if (this.currentToken.equals("<=")) {
                this.readNextToken();
                return new LessThanOrEqualsOperator(lNode, this.parseAdditiveExpression());
            }
            if (this.currentToken.equals(">=")) {
                this.readNextToken();
                return new GreaterThanOrEqualsOperator(lNode, this.parseAdditiveExpression());
            }
        }
        return lNode;
    }

    private SelectorNode parseAdditiveExpression() throws InvalidSelectorException {
        SelectorNode lNode = this.parseMultiplicativeExpression();
        while (!this.isEndOfExpression()) {
            if (this.currentToken.equals("+")) {
                this.readNextToken();
                lNode = new SumOperator(lNode, this.parseMultiplicativeExpression());
                continue;
            }
            if (!this.currentToken.equals("-")) break;
            this.readNextToken();
            lNode = new SubstractOperator(lNode, this.parseMultiplicativeExpression());
        }
        return lNode;
    }

    private SelectorNode parseMultiplicativeExpression() throws InvalidSelectorException {
        SelectorNode lNode = this.parseUnaryExpression();
        while (!this.isEndOfExpression()) {
            if (this.currentToken.equals("*")) {
                this.readNextToken();
                lNode = new MultiplyOperator(lNode, this.parseUnaryExpression());
                continue;
            }
            if (!this.currentToken.equals("/")) break;
            this.readNextToken();
            lNode = new DivideOperator(lNode, this.parseUnaryExpression());
        }
        return lNode;
    }

    private SelectorNode parseUnaryExpression() throws InvalidSelectorException {
        if (this.isEndOfExpression()) {
            throw new InvalidSelectorException("Unexpected end of expression");
        }
        if (this.currentToken.equals("-")) {
            this.readNextToken();
            return new MinusOperator(this.parseBaseExpression());
        }
        if (this.currentToken.equalsIgnoreCase("not")) {
            this.readNextToken();
            return new NotOperator(this.parseBaseExpression());
        }
        return this.parseBaseExpression();
    }

    private SelectorNode parseBaseExpression() throws InvalidSelectorException {
        if (this.isEndOfExpression()) {
            throw new InvalidSelectorException("Unexpected end of expression");
        }
        if (this.currentToken.equals("(")) {
            return this.parseGroupExpression();
        }
        if (this.isLiteral(this.currentToken)) {
            if (this.currentToken.startsWith("'")) {
                return this.parseStringConstant();
            }
            return this.parseNumericConstant();
        }
        if (this.currentToken.equalsIgnoreCase("true")) {
            this.readNextToken();
            return new BooleanLiteral(Boolean.TRUE);
        }
        if (this.currentToken.equalsIgnoreCase("false")) {
            this.readNextToken();
            return new BooleanLiteral(Boolean.FALSE);
        }
        if (this.currentToken.equalsIgnoreCase("null")) {
            this.readNextToken();
            return new NullLiteral();
        }
        if (this.currentToken.equalsIgnoreCase("not true")) {
            this.readNextToken();
            return new BooleanLiteral(Boolean.FALSE);
        }
        if (this.currentToken.equalsIgnoreCase("not false")) {
            this.readNextToken();
            return new BooleanLiteral(Boolean.TRUE);
        }
        if (this.isIdentifier(this.currentToken)) {
            return this.parseIdentifier();
        }
        throw new InvalidSelectorException("Unexpected token : " + this.currentToken);
    }

    private SelectorNode parseGroupExpression() throws InvalidSelectorException {
        this.readNextToken();
        SelectorNode lExpression = this.parseExpression();
        if (this.isEndOfExpression()) {
            throw new InvalidSelectorException("Unexpected end of sub-expression");
        }
        if (!this.currentToken.equals(")")) {
            throw new InvalidSelectorException("Unexpected extra token at end of sub-expression : " + this.currentToken);
        }
        this.readNextToken();
        return lExpression;
    }

    private SelectorNode parseIdentifier() throws InvalidSelectorException {
        String lName = this.currentToken;
        if (!(!lName.startsWith("JMS") || lName.startsWith("JMSX") || lName.startsWith("JMS_") || lName.equals("JMSDeliveryMode") || lName.equals("JMSPriority") || lName.equals("JMSMessageID") || lName.equals("JMSTimestamp") || lName.equals("JMSCorrelationID") || lName.equals("JMSType"))) {
            throw new InvalidSelectorException("Header property " + lName + " cannot be used in a message selector");
        }
        this.readNextToken();
        return new Identifier(lName);
    }

    private SelectorNode parseStringConstant() {
        String lValue = this.currentToken.substring(1, this.currentToken.length() - 1);
        lValue = StringUtils.replaceDoubleSingleQuotes(lValue);
        this.readNextToken();
        return new StringLiteral(lValue);
    }

    private SelectorNode parseNumericConstant() throws InvalidSelectorException {
        String value = this.currentToken;
        this.readNextToken();
        return new NumericLiteral(value);
    }
}

