/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.BytesMessageImpl;
import net.timewalker.ffmq4.common.message.EmptyMessageImpl;
import net.timewalker.ffmq4.common.message.MapMessageImpl;
import net.timewalker.ffmq4.common.message.ObjectMessageImpl;
import net.timewalker.ffmq4.common.message.StreamMessageImpl;
import net.timewalker.ffmq4.common.message.TextMessageImpl;

public final class MessageType {
    public static final byte EMPTY = 1;
    public static final byte BYTES = 2;
    public static final byte MAP = 3;
    public static final byte OBJECT = 4;
    public static final byte STREAM = 5;
    public static final byte TEXT = 6;

    public static AbstractMessage createInstance(byte type) {
        switch (type) {
            case 1: {
                return new EmptyMessageImpl();
            }
            case 2: {
                return new BytesMessageImpl();
            }
            case 3: {
                return new MapMessageImpl();
            }
            case 4: {
                return new ObjectMessageImpl();
            }
            case 5: {
                return new StreamMessageImpl();
            }
            case 6: {
                return new TextMessageImpl();
            }
        }
        throw new IllegalArgumentException("Unsupported message type : " + type);
    }
}

