/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.client;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQClientSettings;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.tcp.nio.NIOTcpMultiplexer;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.async.AsyncTaskManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientEnvironment {
    private static final Log log = LogFactory.getLog(ClientEnvironment.class);
    public static final String SETTINGS_FILE_NAME = "ffmq4.properties";
    private static NIOTcpMultiplexer multiplexer;
    private static AsyncTaskManager asyncTaskManager;
    private static Settings settings;

    public static synchronized Settings getSettings() {
        if (settings == null) {
            settings = ClientEnvironment.loadSettings();
        }
        return settings;
    }

    private static synchronized Settings loadSettings() {
        Properties settings = new Properties();
        try {
            InputStream userIn;
            InputStream defaultIn = FFMQClientSettings.class.getClassLoader().getResourceAsStream("net/timewalker/ffmq4/ffmq4.properties");
            if (defaultIn != null) {
                settings.load(defaultIn);
                defaultIn.close();
            }
            if ((userIn = FFMQClientSettings.class.getClassLoader().getResourceAsStream(SETTINGS_FILE_NAME)) != null) {
                settings.load(userIn);
                userIn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot load settings", (Throwable)e);
        }
        return new Settings(settings);
    }

    public static synchronized NIOTcpMultiplexer getMultiplexer() throws PacketTransportException {
        if (multiplexer == null) {
            multiplexer = new NIOTcpMultiplexer(ClientEnvironment.getSettings(), true);
        }
        return multiplexer;
    }

    public static synchronized AsyncTaskManager getAsyncTaskManager() throws JMSException {
        if (asyncTaskManager == null) {
            int threadPoolMinSize = ClientEnvironment.getSettings().getIntProperty("asyncTaskManager.delivery.threadPool.minSize", 0);
            int threadPoolMaxIdle = ClientEnvironment.getSettings().getIntProperty("asyncTaskManager.delivery.threadPool.maxIdle", 5);
            int threadPoolMaxSize = ClientEnvironment.getSettings().getIntProperty("asyncTaskManager.delivery.threadPool.maxSize", 10);
            asyncTaskManager = new AsyncTaskManager("AsyncTaskManager-client-delivery", threadPoolMinSize, threadPoolMaxIdle, threadPoolMaxSize);
        }
        return asyncTaskManager;
    }

    private ClientEnvironment() {
    }
}

