package com.formos.tapestry.testify.internal;

import org.apache.tapestry5.internal.services.CookieSink;
import org.apache.tapestry5.internal.services.CookieSource;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.services.transform.InjectionProvider2;

import com.formos.tapestry.testify.core.TestifyConstants;


/**
 * Services to support enhanced page/component testing.
 */
public class TestifyModule {
    @SuppressWarnings("unchecked")
	public static void bind(ServiceBinder binder) {
        binder.bind(PerTestDataStore.class, ThreadLocalPerTestDataStore.class).withMarker(Builtin.class);
        binder.bind(ObjectsForComponentsStore.class, SimpleObjectsForComponentsStore.class).scope(TestifyConstants.PERTEST);
        binder.bind(CookieSinkSource.class, TestifyCookieSinkSource.class).scope(TestifyConstants.PERTEST);
    }

    
    public static void contributeServiceLifecycleSource(MappedConfiguration<String, ServiceLifecycle> configuration) {
        configuration.addInstance(TestifyConstants.PERTEST, PerTestServiceLifecycle.class);
    }


    public static void contributeInjectionProvider(OrderedConfiguration<InjectionProvider2> configuration) {
        configuration.overrideInstance("CommonResources", TestifyCommonResourcesInjectionProvider.class, "after:Default");
        configuration.overrideInstance("Default", TestifyDefaultInjectionProvider.class);

        // These are not ideal constraints... it should really be "after everything except service"
        configuration.addInstance("ForComponents", ForComponentsInjectionProvider.class, "after:ComponentResources", "after:CommonResources", "before:Service");
    }


    public static void contributeMasterObjectProvider(OrderedConfiguration<ObjectProvider> configuration, @Local final CookieSinkSource cookies) {
    	ObjectProvider provider = new ObjectProvider() {
    		public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
    			if (objectType.equals(CookieSink.class) || objectType.equals(CookieSource.class)) {
    				return objectType.cast(cookies);
    			} else {
    				return null;
    			}
    		}
    	};

    	configuration.add("TestifyProvider", provider, "before:ServiceOverride");
    }
}
