/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.hasor.core.AppContext;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.binder.AppContextFinder;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataway.daos.GetScriptByPathQuery;
import net.hasor.utils.ResourcesUtils;

@Singleton
public class DatawayFinder
extends AppContextFinder {
    private DataQL dataQL;

    @Inject
    public DatawayFinder(AppContext appContext) {
        super(appContext);
        this.dataQL = (DataQL)appContext.findBindingBean("net.hasor.dataway.config.DatawayModule", DataQL.class);
    }

    public InputStream findResource(final String resourceName) throws IOException {
        if (resourceName.toLowerCase().startsWith("classpath:")) {
            String newResourceName = resourceName.substring("classpath:".length());
            return ResourcesUtils.getResourceAsStream((String)newResourceName);
        }
        QueryResult queryResult = new GetScriptByPathQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiPath", resourceName);
            }
        });
        ListModel listModel = (ListModel)queryResult.getData();
        if (listModel == null || listModel.size() == 0) {
            throw new NullPointerException("import compiler failed -> '" + resourceName + "' not found.");
        }
        String scriptBody = listModel.getObject(0).getValue("pub_script").asString();
        return new ByteArrayInputStream(scriptBody.getBytes());
    }
}

