/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoublePriorityQueue;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleHeaps;
import java.util.NoSuchElementException;

public class DoubleHeapPriorityQueue
extends AbstractDoublePriorityQueue {
    protected double[] heap = DoubleArrays.EMPTY_ARRAY;
    protected int size;
    protected DoubleComparator c;

    public DoubleHeapPriorityQueue(int capacity, DoubleComparator c) {
        if (capacity > 0) {
            this.heap = new double[capacity];
        }
        this.c = c;
    }

    public DoubleHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public DoubleHeapPriorityQueue(DoubleComparator c) {
        this(0, c);
    }

    public DoubleHeapPriorityQueue() {
        this(0, null);
    }

    public DoubleHeapPriorityQueue(double[] a, int size, DoubleComparator c) {
        this(c);
        this.heap = a;
        this.size = size;
        DoubleHeaps.makeHeap(a, size, c);
    }

    public DoubleHeapPriorityQueue(double[] a, DoubleComparator c) {
        this(a, a.length, c);
    }

    public DoubleHeapPriorityQueue(double[] a, int size) {
        this(a, size, null);
    }

    public DoubleHeapPriorityQueue(double[] a) {
        this(a, a.length);
    }

    @Override
    public void enqueue(double x) {
        if (this.size == this.heap.length) {
            this.heap = DoubleArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        DoubleHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public double dequeueDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        double result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            DoubleHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public double firstDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        DoubleHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = DoubleArrays.trim(this.heap, this.size);
    }

    @Override
    public DoubleComparator comparator() {
        return this.c;
    }
}

