/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingConnectionFactory;
import brave.jms.TracingXAConnection;
import brave.jms.TracingXAJMSContext;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;

final class TracingXAConnectionFactory
extends TracingConnectionFactory
implements XAQueueConnectionFactory,
XATopicConnectionFactory {
    static XAConnectionFactory create(XAConnectionFactory delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("xaConnectionFactory == null");
        }
        if (delegate instanceof TracingXAConnectionFactory) {
            return delegate;
        }
        return new TracingXAConnectionFactory(delegate, jmsTracing);
    }

    TracingXAConnectionFactory(XAConnectionFactory delegate, JmsTracing jmsTracing) {
        super(delegate, jmsTracing);
    }

    public XAConnection createXAConnection() throws JMSException {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAConnection.create(xacf.createXAConnection(), this.jmsTracing);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAConnection.create(xacf.createXAConnection(userName, password), this.jmsTracing);
    }

    public XAJMSContext createXAContext() {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAJMSContext.create(xacf.createXAContext(), this.jmsTracing);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAJMSContext.create(xacf.createXAContext(userName, password), this.jmsTracing);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        this.checkQueueConnectionFactory();
        XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXAQueueConnection(), this.jmsTracing);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        this.checkQueueConnectionFactory();
        XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXAQueueConnection(userName, password), this.jmsTracing);
    }

    @Override
    void checkQueueConnectionFactory() {
        if ((this.types & 0x10) != 16) {
            throw new IllegalStateException(this.delegate + " is not an XAQueueConnectionFactory");
        }
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        this.checkTopicConnectionFactory();
        XATopicConnectionFactory xaqcf = (XATopicConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXATopicConnection(), this.jmsTracing);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        this.checkTopicConnectionFactory();
        XATopicConnectionFactory xaqcf = (XATopicConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXATopicConnection(userName, password), this.jmsTracing);
    }

    @Override
    void checkTopicConnectionFactory() {
        if ((this.types & 0x20) != 32) {
            throw new IllegalStateException(this.delegate + " is not an XATopicConnectionFactory");
        }
    }
}

